/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.EmpiricalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class KernelDensityGen
extends RandomVariateGen {
    protected RandomVariateGen kernelGen;
    protected double bandwidth;
    protected boolean positive;

    public KernelDensityGen(RandomStream s, EmpiricalDist dist, RandomVariateGen kGen, double h) {
        super(s, dist);
        if (h < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        if (kGen == null) {
            throw new IllegalArgumentException("kGen == null");
        }
        this.kernelGen = kGen;
        this.bandwidth = h;
    }

    public KernelDensityGen(RandomStream s, EmpiricalDist dist, NormalGen kGen) {
        this(s, dist, kGen, 0.77639 * KernelDensityGen.getBaseBandwidth(dist));
    }

    public static double getBaseBandwidth(EmpiricalDist dist) {
        double r = dist.getInterQuartileRange() / 1.34;
        double sigma = dist.getSampleStandardDeviation();
        if (sigma < r) {
            r = sigma;
        }
        return 1.36374 * r / Math.exp(0.2 * Math.log(dist.getN()));
    }

    public void setBandwidth(double h) {
        if (h < 0.0) {
            throw new IllegalArgumentException("h < 0");
        }
        this.bandwidth = h;
    }

    public void setPositiveReflection(boolean reflect) {
        this.positive = reflect;
    }

    @Override
    public double nextDouble() {
        double x = this.dist.inverseF(this.stream.nextDouble()) + this.bandwidth * this.kernelGen.nextDouble();
        if (this.positive) {
            return Math.abs(x);
        }
        return x;
    }
}

