/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;

public class NormalACRGen
extends NormalGen {
    public NormalACRGen(RandomStream s, double mu, double sigma) {
        super(s, null);
        this.setParams(mu, sigma);
    }

    public NormalACRGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public NormalACRGen(RandomStream s, NormalDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getMu(), dist.getSigma());
        }
    }

    @Override
    public double nextDouble() {
        return NormalACRGen.nextDouble(this.stream, this.mu, this.sigma);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double nextDouble(RandomStream s, double mu, double sigma) {
        double x;
        double z;
        double rn;
        double X;
        double c1 = 1.448242853;
        double c2 = 3.307147487;
        double c3 = 1.46754004;
        double d1 = 1.036467755;
        double d2 = 5.295844968;
        double d3 = 3.631288474;
        double hm = 0.483941449;
        double zm = 0.107981933;
        double hp = 4.132731354;
        double zp = 18.52161694;
        double phln = 0.4515827053;
        double hm1 = 0.516058551;
        double hp1 = 3.132731354;
        double hzm = 0.375959516;
        double hzmp = 0.591923442;
        double as = 0.8853395638;
        double bs = 0.2452635696;
        double cs = 0.2770276848;
        double b = 0.5029324303;
        double x0 = 0.4571828819;
        double ym = 0.187308492;
        double ss = 0.7270572718;
        double t = 0.03895759111;
        double y = s.nextDouble();
        if (y > 0.516058551) {
            X = 4.132731354 * y - 3.132731354;
            return mu + sigma * X;
        }
        if (y < 0.107981933) {
            double rn2 = 18.52161694 * y - 1.0;
            X = rn2 > 0.0 ? 1.0 + rn2 : -1.0 + rn2;
            return mu + sigma * X;
        }
        if (y < 0.483941449) {
            rn = s.nextDouble();
            double d = z = (rn = rn - 1.0 + rn) > 0.0 ? 2.0 - rn : -2.0 - rn;
            if ((1.448242853 - y) * (1.46754004 + Math.abs(z)) < 3.307147487) {
                X = z;
                return mu + sigma * X;
            }
            x = rn * rn;
            if ((y + 1.036467755) * (3.631288474 + x) < 5.295844968) {
                X = rn;
                return mu + sigma * X;
            }
            if (0.591923442 - y < Math.exp(-(z * z + 0.4515827053) / 2.0)) {
                X = z;
                return mu + sigma * X;
            }
            if (y + 0.375959516 < Math.exp(-(x + 0.4515827053) / 2.0)) {
                X = rn;
                return mu + sigma * X;
            }
        }
        do {
            if ((z = 0.4571828819 - 0.7270572718 * (x = s.nextDouble()) - (y = 0.187308492 * s.nextDouble())) > 0.0) {
                rn = 2.0 + y / x;
            } else {
                x = 1.0 - x;
                y = 0.187308492 - y;
                rn = -(2.0 + y / x);
            }
            if (!((y - 0.8853395638 + x) * (0.2770276848 + x) + 0.2452635696 < 0.0)) continue;
            X = rn;
            return mu + sigma * X;
        } while (!(y < x + 0.03895759111) || !(rn * rn < 4.0 * (0.5029324303 - Math.log(x))));
        X = rn;
        return mu + sigma * X;
    }
}

