/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.UniformIntDist;
import umontreal.ssj.randvar.RandomVariateGenInt;
import umontreal.ssj.rng.RandomStream;

public class UniformIntGen
extends RandomVariateGenInt {
    protected int left;
    protected int right;

    public UniformIntGen(RandomStream s, int i, int j) {
        super(s, new UniformIntDist(i, j));
        this.setParams(i, j);
    }

    public UniformIntGen(RandomStream s, UniformIntDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getI(), dist.getJ());
        }
    }

    public static int nextInt(RandomStream s, int i, int j) {
        return UniformIntDist.inverseF(i, j, s.nextDouble());
    }

    public int getI() {
        return this.left;
    }

    public int getJ() {
        return this.right;
    }

    protected void setParams(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("j < i");
        }
        this.left = i;
        this.right = j;
    }
}

