/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvarmulti;

import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.randvarmulti.RandomMultivariateGen;

public class IIDMultivariateGen
extends RandomMultivariateGen {
    public IIDMultivariateGen(RandomVariateGen gen1, int d) {
        this.setGen1(gen1);
        this.stream = gen1.getStream();
        this.dimension = d;
    }

    public void setDimension(int d) {
        this.dimension = d;
    }

    @Override
    public void nextPoint(double[] p) {
        if (p.length != this.dimension) {
            throw new IllegalArgumentException(String.format("p's dimension (%d) does not mach dimension (%d)", p.length, this.dimension));
        }
        for (int i = 0; i < this.dimension; ++i) {
            p[i] = this.gen1.nextDouble();
        }
    }

    public void setGen1(RandomVariateGen gen1) {
        if (gen1 == null) {
            throw new NullPointerException("gen1 is null");
        }
        this.gen1 = gen1;
    }

    public RandomVariateGen getGen1() {
        return this.gen1;
    }

    public String toString() {
        return this.dimension + "-dimensional vector of i.i.d. " + this.gen1.getDistribution().toString();
    }
}

