/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat;

import java.util.logging.Level;
import java.util.logging.Logger;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.stat.StatProbe;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.list.ListOfTalliesWithCovariance;
import umontreal.ssj.util.MultivariateFunction;
import umontreal.ssj.util.PrintfFormat;

public class FunctionOfMultipleMeansTally
extends StatProbe
implements Cloneable {
    private ListOfTalliesWithCovariance<Tally> ta;
    protected MultivariateFunction func;
    private double[] temp;
    private double[] delta;
    private Logger log = Logger.getLogger("umontreal.ssj.stat");
    protected CIType confidenceInterval = CIType.CI_NONE;
    protected double level = 0.95;

    public FunctionOfMultipleMeansTally(MultivariateFunction func, int d) {
        this.ta = ListOfTalliesWithCovariance.createWithTally(d);
        this.ta.setUnmodifiable();
        this.func = func;
        this.internalInit();
    }

    public FunctionOfMultipleMeansTally(MultivariateFunction func, String name, int d) {
        this.ta = ListOfTalliesWithCovariance.createWithTally(d);
        this.ta.setName(name);
        this.ta.setUnmodifiable();
        this.func = func;
        this.name = name;
        this.internalInit();
    }

    public FunctionOfMultipleMeansTally(MultivariateFunction func, ListOfTalliesWithCovariance<Tally> ta) {
        if (ta == null) {
            throw new NullPointerException("The list of tallies cannot be null");
        }
        this.ta = ta;
        this.func = func;
        ta.setUnmodifiable();
        this.name = ta.getName();
        this.internalInit();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.ta.setName(name);
    }

    public ListOfTalliesWithCovariance<Tally> getListOfTallies() {
        return this.ta;
    }

    public MultivariateFunction getFunction() {
        return this.func;
    }

    public int getDimension() {
        return this.ta.size();
    }

    public void add(double ... x) {
        if (x.length != this.ta.size()) {
            throw new IllegalArgumentException("Incompatible length of vectors of observations: given length is " + x.length + ", but required length is " + this.ta.size());
        }
        if (this.collect) {
            this.ta.add(x);
        }
    }

    public int numberObs() {
        return this.ta.numberObs();
    }

    @Override
    public double average() {
        if (this.temp.length != this.ta.size()) {
            this.temp = new double[this.ta.size()];
        }
        this.ta.average(this.temp);
        return this.func.evaluate(this.temp);
    }

    public double variance() {
        int i;
        if (this.ta.numberObs() < 2) {
            this.log.logp(Level.WARNING, "FunctionOfMultipleMeansTally", "variance", "FunctionOfMultipleMeansTally " + this.name + ":   calling variance() with " + this.ta.numberObs() + " observation");
            return Double.NaN;
        }
        if (this.temp.length != this.ta.size()) {
            this.temp = new double[this.ta.size()];
            this.delta = new double[this.ta.size()];
        }
        this.ta.average(this.temp);
        for (i = 0; i < this.delta.length; ++i) {
            this.delta[i] = this.func.evaluateGradient(i, this.temp);
        }
        for (i = 0; i < this.temp.length; ++i) {
            this.temp[i] = 0.0;
            for (int j = 0; j < this.delta.length; ++j) {
                int n = i;
                this.temp[n] = this.temp[n] + this.delta[j] * this.ta.covariance(j, i);
            }
        }
        double sigma = 0.0;
        for (int i2 = 0; i2 < this.temp.length; ++i2) {
            sigma += this.temp[i2] * this.delta[i2];
        }
        return sigma < 0.0 ? 0.0 : sigma;
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public void confidenceIntervalDelta(double level, double[] centerAndRadius) {
        centerAndRadius[0] = this.average();
        double z = NormalDist.inverseF01(0.5 * (level + 1.0));
        centerAndRadius[1] = z * Math.sqrt(this.variance() / (double)this.numberObs());
    }

    public String formatCIDelta(double level, int d) {
        PrintfFormat str = new PrintfFormat();
        double[] ci = new double[2];
        this.confidenceIntervalDelta(level, ci);
        str.append("  " + 100.0 * level + "%");
        str.append(" confidence interval for function of means: (");
        str.append(7 + d, d, d - 1, ci[0] - ci[1]).append(',');
        str.append(7 + d, d, d - 1, ci[0] + ci[1]).append(" )" + PrintfFormat.NEWLINE);
        return str.toString();
    }

    public String formatCIDelta(double level) {
        return this.formatCIDelta(level, 3);
    }

    @Override
    public String report() {
        PrintfFormat str = new PrintfFormat();
        str.append("REPORT on Tally stat. collector ==> " + this.name);
        str.append(PrintfFormat.NEWLINE + "    func. of averages    standard dev.  ");
        str.append("num. obs." + PrintfFormat.NEWLINE);
        str.append(20, 3, 2, this.average());
        str.append(13, 3, 2, this.standardDeviation());
        str.append(13, this.numberObs()).append(PrintfFormat.NEWLINE);
        if (this.confidenceInterval == CIType.CI_DELTA) {
            str.append(this.formatCIDelta(this.level));
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reportAndCIDelta(double level, int d) {
        CIType oldCIType = this.confidenceInterval;
        double oldLevel = this.level;
        try {
            this.confidenceInterval = CIType.CI_DELTA;
            this.level = level;
            String string = this.report();
            return string;
        }
        finally {
            this.confidenceInterval = oldCIType;
            this.level = oldLevel;
        }
    }

    public String reportAndCIDelta(double level) {
        return this.reportAndCIDelta(level, 3);
    }

    @Override
    public String shortReportHeader() {
        PrintfFormat pf = new PrintfFormat();
        pf.append(-20, " func. of averages").append("   ");
        pf.append(-9, "std. dev.");
        if (this.showNobs) {
            pf.append("   ").append(-5, "nobs.");
        }
        if (this.confidenceInterval != CIType.CI_NONE) {
            pf.append("   ").append(-25, "conf. int.");
        }
        return pf.toString();
    }

    @Override
    public String shortReport() {
        PrintfFormat pf = new PrintfFormat();
        pf.append(20, 3, 2, this.average()).append("   ");
        if (this.numberObs() >= 2) {
            pf.append(9, 3, 2, this.standardDeviation());
        } else {
            pf.append(9, "---");
        }
        if (this.showNobs) {
            pf.append("   ").append(5, this.numberObs());
        }
        if (this.confidenceInterval == CIType.CI_DELTA) {
            double[] ci = new double[2];
            this.confidenceIntervalDelta(this.level, ci);
            pf.append("   ").append(100.0 * this.level + "% (");
            pf.append(9, 3, 2, ci[0] - ci[1]).append(',');
            pf.append(9, 3, 2, ci[0] + ci[1]).append(")");
        }
        return pf.toString();
    }

    public double getConfidenceLevel() {
        return this.level;
    }

    public void setConfidenceLevel(double level) {
        if (level < 0.0) {
            throw new IllegalArgumentException("level < 0");
        }
        if (level >= 1.0) {
            throw new IllegalArgumentException("level >= 1");
        }
        this.level = level;
    }

    public void setConfidenceIntervalNone() {
        this.confidenceInterval = CIType.CI_NONE;
    }

    public void setConfidenceIntervalDelta() {
        this.confidenceInterval = CIType.CI_DELTA;
    }

    public void setShowNumberObs(boolean showNumObs) {
        this.showNobs = showNumObs;
    }

    @Override
    public double min() {
        return Double.NaN;
    }

    @Override
    public double max() {
        return Double.NaN;
    }

    @Override
    public double sum() {
        return Double.NaN;
    }

    private void internalInit() {
        if (this.func.getDimension() != this.ta.size() && this.func.getDimension() != -1) {
            throw new IllegalArgumentException("The dimension of the function must be equal to d, or equal to -1");
        }
        this.temp = new double[this.ta.size()];
        this.delta = new double[this.ta.size()];
    }

    @Override
    public void init() {
        this.ta.init();
        this.internalInit();
    }

    @Override
    public FunctionOfMultipleMeansTally clone() {
        FunctionOfMultipleMeansTally mta;
        try {
            mta = (FunctionOfMultipleMeansTally)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("CloneNotSupportedException for a class implementing Cloneable");
        }
        mta.ta = new ListOfTalliesWithCovariance();
        for (int i = 0; i < this.ta.size(); ++i) {
            mta.ta.add(((Tally)this.ta.get(i)).clone());
        }
        mta.temp = new double[this.ta.size()];
        mta.delta = new double[this.ta.size()];
        return mta;
    }

    private static enum CIType {
        CI_NONE,
        CI_DELTA;

    }
}

