/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.list;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import umontreal.ssj.stat.FunctionOfMultipleMeansTally;
import umontreal.ssj.stat.list.ListOfStatProbes;
import umontreal.ssj.util.MultivariateFunction;

public class ListOfFunctionOfMultipleMeansTallies<E extends FunctionOfMultipleMeansTally>
extends ListOfStatProbes<E> {
    double[][] temp = null;

    public ListOfFunctionOfMultipleMeansTallies() {
    }

    public ListOfFunctionOfMultipleMeansTallies(String name) {
        super(name);
    }

    public static ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> create(MultivariateFunction func, int d, int size) {
        ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally> list = new ListOfFunctionOfMultipleMeansTallies<FunctionOfMultipleMeansTally>();
        for (int i = 0; i < size; ++i) {
            list.add(new FunctionOfMultipleMeansTally(func, d));
        }
        return list;
    }

    public void add(double[][] x) {
        if (x.length != this.size()) {
            throw new IllegalArgumentException("Invalid number of vectors of observations: the given length is " + x.length + ", but the required length is " + this.size());
        }
        if (this.collect) {
            for (int i = 0; i < this.size(); ++i) {
                FunctionOfMultipleMeansTally ta = (FunctionOfMultipleMeansTally)this.get(i);
                if (ta == null) continue;
                ta.add(x[i]);
            }
        }
    }

    public void add(DoubleMatrix2D x) {
        if (x.rows() != this.size()) {
            throw new IllegalArgumentException("Invalid number of vectors of observations: the given number is " + x.rows() + ", but the required number is " + this.size());
        }
        if (this.collect) {
            for (int i = 0; i < this.size(); ++i) {
                FunctionOfMultipleMeansTally ta = (FunctionOfMultipleMeansTally)this.get(i);
                if (ta == null) continue;
                ta.add(x.viewRow(i).toArray());
            }
        }
    }

    public void addSameDimension(double[] ... x) {
        int i;
        int l = this.size();
        int d = this.getDimension();
        if (x.length != d) {
            throw new IllegalArgumentException("The length of the given array must be " + d + " while its actual length is " + x.length);
        }
        if (x.length == 0 || l == 0) {
            return;
        }
        if (l != x[0].length) {
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        for (i = 0; i < x.length - 1; ++i) {
            if (x[i].length == x[i + 1].length) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != l || this.temp[0].length != d) {
            this.temp = new double[l][d];
        }
        for (i = 0; i < l; ++i) {
            for (int j = 0; j < d; ++j) {
                this.temp[i][j] = x[j][i];
            }
        }
        this.add(this.temp);
    }

    public void addSameDimension(DoubleMatrix1D ... x) {
        int i;
        int l = this.size();
        int d = this.getDimension();
        if (x.length != d) {
            throw new IllegalArgumentException("The length of the given array must be " + d + " while its actual length is " + x.length);
        }
        if (x.length == 0 || l == 0) {
            return;
        }
        if (l != x[0].size()) {
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        for (i = 0; i < x.length - 1; ++i) {
            if (x[i].size() == x[i + 1].size()) continue;
            throw new IllegalArgumentException("The given arrays must have the same length");
        }
        if (this.temp == null || this.temp.length != l || this.temp[0].length != d) {
            this.temp = new double[l][d];
        }
        for (i = 0; i < l; ++i) {
            for (int j = 0; j < d; ++j) {
                this.temp[i][j] = x[j].get(i);
            }
        }
        this.add(this.temp);
    }

    public int getDimension() {
        if (this.size() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally t0 = (FunctionOfMultipleMeansTally)this.get(0);
        return t0 == null ? 0 : t0.getDimension();
    }

    public int numberObs() {
        if (this.size() == 0) {
            return 0;
        }
        FunctionOfMultipleMeansTally t0 = (FunctionOfMultipleMeansTally)this.get(0);
        return t0 == null ? 0 : t0.numberObs();
    }

    public boolean areAllNumberObsEqual() {
        int l = this.size();
        int n = this.numberObs();
        for (int i = 1; i < l; ++i) {
            FunctionOfMultipleMeansTally t = (FunctionOfMultipleMeansTally)this.get(i);
            if (t.numberObs() == n) continue;
            return false;
        }
        return true;
    }

    @Override
    public void average(double[] a) {
        super.average(a);
        for (int i = 0; i < a.length; ++i) {
            if (Double.isNaN(a[i]) || ((FunctionOfMultipleMeansTally)this.get(i)).numberObs() != 0) continue;
            a[i] = Double.NaN;
        }
    }

    public void variance(double[] v) {
        if (v.length != this.size()) {
            throw new IllegalArgumentException("Incompatible array length: the given length is " + v.length + " while the required length is " + this.size());
        }
        for (int i = 0; i < v.length; ++i) {
            FunctionOfMultipleMeansTally tally = (FunctionOfMultipleMeansTally)this.get(i);
            v[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.variance();
        }
    }

    public void standardDeviation(double[] v) {
        if (v.length != this.size()) {
            throw new IllegalArgumentException("Incompatible array length: the given length is " + v.length + " while the required length is " + this.size());
        }
        for (int i = 0; i < v.length; ++i) {
            FunctionOfMultipleMeansTally tally = (FunctionOfMultipleMeansTally)this.get(i);
            v[i] = tally == null || tally.numberObs() < 2 ? Double.NaN : tally.standardDeviation();
        }
    }

    @Override
    public ListOfFunctionOfMultipleMeansTallies<E> clone() {
        ListOfFunctionOfMultipleMeansTallies clone = (ListOfFunctionOfMultipleMeansTallies)super.clone();
        if (this.temp != null) {
            clone.temp = new double[this.temp.length][this.temp[0].length];
            for (int i = 0; i < this.temp.length; ++i) {
                int j = 0;
                while (j < this.temp[i].length) {
                    clone.temp[i][j] = this.temp[i][j];
                    ++i;
                }
            }
        }
        return clone;
    }
}

