/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stat.list.lincv;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import umontreal.ssj.probdist.StudentDist;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.stat.TallyStore;
import umontreal.ssj.stat.list.ListOfTalliesWithCovariance;

public class ListOfTalliesWithCV<E extends Tally>
extends ListOfTalliesWithCovariance<E> {
    private static Algebra alg = new Algebra();
    private DoubleMatrix2D beta;
    private double[] exp;
    private double[] tmp;
    private int q;
    private DoubleMatrix2D tempPP;
    private DoubleMatrix2D tempQQ;
    private DoubleMatrix2D tempPQ;
    private DoubleMatrix2D tempQP;

    public ListOfTalliesWithCV() {
    }

    public ListOfTalliesWithCV(String name) {
        super(name);
    }

    public static ListOfTalliesWithCV<Tally> createWithTally(int p, int q) {
        ListOfTalliesWithCV<Tally> list = new ListOfTalliesWithCV<Tally>();
        int size = p + q;
        for (int i = 0; i < size; ++i) {
            list.add(new Tally());
        }
        list.setNumControlVariables(q);
        list.init();
        return list;
    }

    public static ListOfTalliesWithCV<TallyStore> createWithTallyStore(int p, int q) {
        ListOfTalliesWithCV<TallyStore> list = new ListOfTalliesWithCV<TallyStore>();
        int size = p + q;
        for (int i = 0; i < size; ++i) {
            list.add(new TallyStore());
        }
        list.setNumControlVariables(q);
        list.init();
        return list;
    }

    @Override
    public void init() {
        super.init();
        this.internalInit();
    }

    private void internalInit() {
        int p = this.sizeWithoutCV();
        this.beta = new DenseDoubleMatrix2D(this.q, p);
        this.exp = new double[this.q];
        this.tmp = new double[p + this.q];
        this.tempPP = new DenseDoubleMatrix2D(p, p);
        this.tempQQ = new DenseDoubleMatrix2D(this.q, this.q);
        this.tempPQ = new DenseDoubleMatrix2D(p, this.q);
        this.tempQP = new DenseDoubleMatrix2D(this.q, p);
        this.setUnmodifiable();
    }

    public DoubleMatrix2D getBeta() {
        return this.beta;
    }

    public void setBeta(DoubleMatrix2D beta) {
        if (beta.rows() != this.getNumControlVariables()) {
            throw new IllegalArgumentException("The number of rows in beta must be equal to q");
        }
        if (beta.columns() != this.sizeWithoutCV()) {
            throw new IllegalArgumentException("The number of columns in beta must be equal to p");
        }
        this.beta = beta;
    }

    public double getExpectedValue(int i) {
        return this.exp[i];
    }

    public void setExpectedValue(int i, double e) {
        this.exp[i] = e;
    }

    public double[] getExpectedValues() {
        return this.exp;
    }

    public void setExpectedValues(double[] exp) {
        if (exp.length != this.exp.length) {
            throw new IllegalArgumentException("Invalid length of exp");
        }
        this.exp = exp;
    }

    public int sizeWithoutCV() {
        return this.size() - this.q;
    }

    public int getNumControlVariables() {
        return this.q;
    }

    public void setNumControlVariables(int q) {
        if (this.beta != null) {
            throw new IllegalArgumentException("Cannot change the number of control variables");
        }
        if (q < 0 || q >= this.size()) {
            throw new IllegalArgumentException("q is negative or greater than or equal to " + this.size());
        }
        this.q = q;
    }

    public void correlationX(DoubleMatrix2D c) {
        int l = this.sizeWithoutCV();
        if (c.rows() != l) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != l) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < l; ++i1) {
            for (int i2 = 0; i2 < l; ++i2) {
                c.setQuick(i1, i2, this.correlation(i1, i2));
            }
        }
    }

    public void covarianceX(DoubleMatrix2D c) {
        int l = this.sizeWithoutCV();
        if (c.rows() != l) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != l) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < l; ++i1) {
            for (int i2 = 0; i2 < l; ++i2) {
                c.setQuick(i1, i2, this.covariance(i1, i2));
            }
        }
    }

    public void correlationC(DoubleMatrix2D c) {
        int p = this.sizeWithoutCV();
        int q = this.getNumControlVariables();
        if (c.rows() != q) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != q) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < q; ++i1) {
            for (int i2 = 0; i2 < q; ++i2) {
                c.setQuick(i1, i2, this.correlation(p + i1, p + i2));
            }
        }
    }

    public void covarianceC(DoubleMatrix2D c) {
        int p = this.sizeWithoutCV();
        int q = this.getNumControlVariables();
        if (c.rows() != q) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != q) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < q; ++i1) {
            for (int i2 = 0; i2 < q; ++i2) {
                c.setQuick(i1, i2, this.covariance(p + i1, p + i2));
            }
        }
    }

    public void correlationCX(DoubleMatrix2D c) {
        int p = this.sizeWithoutCV();
        int q = this.getNumControlVariables();
        if (c.rows() != q) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != p) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < q; ++i1) {
            for (int i2 = 0; i2 < p; ++i2) {
                c.setQuick(i1, i2, this.correlation(p + i1, i2));
            }
        }
    }

    public void covarianceCX(DoubleMatrix2D c) {
        int p = this.sizeWithoutCV();
        int q = this.getNumControlVariables();
        if (c.rows() != q) {
            throw new IllegalArgumentException("Invalid number of rows in covariance matrix");
        }
        if (c.columns() != p) {
            throw new IllegalArgumentException("Invalid number of columns in covariance matrix");
        }
        for (int i1 = 0; i1 < q; ++i1) {
            for (int i2 = 0; i2 < p; ++i2) {
                c.setQuick(i1, i2, this.covariance(p + i1, i2));
            }
        }
    }

    public void add(double[] x, double[] c) {
        if (x.length != this.sizeWithoutCV()) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        if (c.length != this.getNumControlVariables()) {
            throw new IllegalArgumentException("Invalid length of c");
        }
        System.arraycopy(x, 0, this.tmp, 0, x.length);
        System.arraycopy(c, 0, this.tmp, x.length, c.length);
        this.add(this.tmp);
    }

    public void add(double x, double[] c) {
        if (this.sizeWithoutCV() != 1) {
            throw new IllegalArgumentException("Cannot use this method if p != 1");
        }
        if (c.length != this.getNumControlVariables()) {
            throw new IllegalArgumentException("Invalid length of c");
        }
        this.tmp[0] = x;
        System.arraycopy(c, 0, this.tmp, 1, c.length);
        this.add(this.tmp);
    }

    public void add(double x, double c) {
        if (this.sizeWithoutCV() != 1) {
            throw new IllegalArgumentException("Cannot use this method if p != 1");
        }
        if (this.getNumControlVariables() != 1) {
            throw new IllegalArgumentException("Cannot use this method if q != 1");
        }
        this.tmp[0] = x;
        this.tmp[1] = c;
        this.add(this.tmp);
    }

    public double averageWithCV(int i) {
        int p = this.sizeWithoutCV();
        if (i >= p) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        Tally tally = (Tally)this.get(i);
        if (tally == null || tally.numberObs() == 0) {
            return Double.NaN;
        }
        double avg = tally.average();
        for (int j = 0; j < this.q; ++j) {
            avg -= this.beta.getQuick(j, i) * (((Tally)this.get(p + j)).average() - this.exp[j]);
        }
        return avg;
    }

    public void covarianceWithCV(DoubleMatrix2D covCV) {
        int p = this.sizeWithoutCV();
        int q = this.getNumControlVariables();
        if (covCV.rows() != p || covCV.columns() != q) {
            throw new IllegalArgumentException("Invalid dimensions of covCV");
        }
        DoubleMatrix2D covX = covCV;
        this.covarianceX(covX);
        DoubleMatrix2D covC = this.tempQQ;
        this.covarianceC(covC);
        DoubleMatrix2D covCX = this.tempQP;
        this.covarianceCX(covCX);
        this.beta.viewDice().zMult(covC, this.tempPQ).zMult(this.beta, covCV, 1.0, 1.0, false, false);
        this.beta.viewDice().zMult(covCX, covCV, -2.0, 1.0, false, false);
    }

    public double covarianceWithCV(int i, int j) {
        int p = this.sizeWithoutCV();
        if (i >= p || j >= p) {
            throw new IllegalArgumentException("i >= p or j >= p");
        }
        double cov = this.covariance(i, j);
        DoubleMatrix2D covC = this.tempQQ;
        this.covarianceC(covC);
        DoubleMatrix2D covCX = this.tempQP;
        this.covarianceCX(covCX);
        cov += this.beta.viewColumn(i).zDotProduct(covC.zMult(this.beta.viewColumn(j), null));
        cov -= covCX.viewColumn(i).zDotProduct(this.beta.viewColumn(j));
        return cov -= covCX.viewColumn(j).zDotProduct(this.beta.viewColumn(i));
    }

    public void averageWithCV(double[] a) {
        int p = this.sizeWithoutCV();
        if (a.length != p) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + a.length + ", required length is " + p);
        }
        for (int i = 0; i < p; ++i) {
            a[i] = this.averageWithCV(i);
        }
    }

    public void averageX(double[] a) {
        int l = this.sizeWithoutCV();
        if (a.length != l) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + a.length + ", required length is " + l);
        }
        for (int i = 0; i < a.length; ++i) {
            Tally tally = (Tally)this.get(i);
            double d = a[i] = tally == null ? Double.NaN : tally.average();
            if (tally.numberObs() != 0) continue;
            a[i] = Double.NaN;
        }
    }

    public void averageC(double[] a) {
        int p = this.sizeWithoutCV();
        int l = this.getNumControlVariables();
        if (a.length != l) {
            throw new IllegalArgumentException("Invalid length of the given array: given length is " + a.length + ", required length is " + l);
        }
        for (int i = 0; i < a.length; ++i) {
            Tally tally = (Tally)this.get(i + p);
            double d = a[i] = tally == null ? Double.NaN : tally.average();
            if (tally.numberObs() != 0) continue;
            a[i] = Double.NaN;
        }
    }

    public void standardDeviationWithCV(double[] std) {
        int l = this.sizeWithoutCV();
        if (l != std.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        DoubleMatrix2D covCV = this.tempPP;
        this.covarianceWithCV(covCV);
        for (int i = 0; i < std.length; ++i) {
            std[i] = Math.sqrt(covCV.getQuick(i, i));
        }
    }

    public void varianceWithCV(double[] v) {
        int l = this.sizeWithoutCV();
        if (l != v.length) {
            throw new IllegalArgumentException("Invalid length of given array");
        }
        DoubleMatrix2D covCV = this.tempPP;
        this.covarianceWithCV(covCV);
        for (int i = 0; i < v.length; ++i) {
            v[i] = covCV.getQuick(i, i);
        }
    }

    public void confidenceIntervalStudentWithCV(int i, double level, double[] centerAndRadius) {
        Tally tally = (Tally)this.get(i);
        int numObs = tally.numberObs();
        if (numObs < 2) {
            throw new RuntimeException("Calling confidenceIntervalStudent with < 2 Observations");
        }
        centerAndRadius[0] = this.averageWithCV(i);
        double t = StudentDist.inverseF(numObs - 1, 0.5 * (level + 1.0));
        centerAndRadius[1] = t * Math.sqrt(this.covarianceWithCV(i, i) / (double)numObs);
    }

    public void estimateBeta() {
        DoubleMatrix2D covC = this.tempQQ;
        this.covarianceC(covC);
        DoubleMatrix2D covCX = this.tempQP;
        this.covarianceCX(covCX);
        this.beta = alg.solve(covC, covCX);
        assert (this.beta.rows() == this.getNumControlVariables() && this.beta.columns() == this.sizeWithoutCV());
    }

    @Override
    public ListOfTalliesWithCV<E> clone() {
        ListOfTalliesWithCV l = (ListOfTalliesWithCV)super.clone();
        l.beta = (DoubleMatrix2D)this.beta.clone();
        l.exp = (double[])this.exp.clone();
        l.tmp = (double[])this.tmp.clone();
        l.q = this.q;
        l.tempPP = (DoubleMatrix2D)this.tempPP.clone();
        l.tempQQ = (DoubleMatrix2D)this.tempQQ.clone();
        l.tempPQ = (DoubleMatrix2D)this.tempPQ.clone();
        l.tempQP = (DoubleMatrix2D)this.tempQP.clone();
        return l;
    }
}

