/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.stochprocess;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import umontreal.ssj.probdist.NormalDist;
import umontreal.ssj.randvar.NormalGen;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.stochprocess.MultivariateStochasticProcess;
import umontreal.ssj.util.DMatrix;

public class MultivariateBrownianMotion
extends MultivariateStochasticProcess {
    protected NormalGen gen;
    protected double[] mu;
    protected double[] sigma;
    protected double[][] corrZ;
    protected DoubleMatrix2D covZ;
    protected DoubleMatrix2D covZCholDecomp;
    protected CholeskyDecomposition decomp;
    protected boolean covZiSCholDecomp;
    protected double[] dt;
    protected double[] sqrdt;

    protected MultivariateBrownianMotion() {
    }

    public MultivariateBrownianMotion(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, RandomStream stream) {
        this.setParams(c, x0, mu, sigma, corrZ);
        this.gen = new NormalGen(stream, new NormalDist());
    }

    public MultivariateBrownianMotion(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ, NormalGen gen) {
        this.setParams(c, x0, mu, sigma, corrZ);
        this.gen = gen;
    }

    @Override
    public void nextObservationVector(double[] obs) {
        if (!this.covZiSCholDecomp) {
            this.initCovZCholDecomp();
        }
        for (int i = 0; i < this.c; ++i) {
            double z = 0.0;
            for (int k = 0; k < this.c; ++k) {
                z += this.covZCholDecomp.getQuick(i, k) * this.gen.nextDouble();
            }
            obs[i] = this.path[this.c * this.observationIndex + i] + this.mu[i] * this.dt[this.observationIndex] + this.sqrdt[this.observationIndex] * z;
            this.path[this.c * (this.observationIndex + 1) + i] = obs[i];
        }
        ++this.observationIndex;
    }

    public double[] nextObservationVector() {
        double[] obs = new double[this.c];
        this.nextObservationVector(obs);
        return obs;
    }

    public double[] nextObservationVector(double nextTime, double[] obs) {
        if (!this.covZiSCholDecomp) {
            this.initCovZCholDecomp();
        }
        this.t[this.observationIndex + 1] = nextTime;
        for (int i = 0; i < this.c; ++i) {
            double z = 0.0;
            for (int k = 0; k < this.c; ++k) {
                z += this.covZCholDecomp.getQuick(i, k) * this.gen.nextDouble();
            }
            obs[i] = this.path[this.c * this.observationIndex + i] + this.mu[i] * (this.t[this.observationIndex + 1] - this.t[this.observationIndex]) + Math.sqrt(this.t[this.observationIndex + 1] - this.t[this.observationIndex]) * z;
            this.path[this.c * (this.observationIndex + 1) + i] = obs[i];
        }
        ++this.observationIndex;
        return obs;
    }

    public double[] nextObservationVector(double[] x, double dt) {
        double[] obs = new double[this.c];
        if (!this.covZiSCholDecomp) {
            this.initCovZCholDecomp();
        }
        for (int i = 0; i < this.c; ++i) {
            double z = 0.0;
            for (int k = 0; k < this.c; ++k) {
                z += this.covZCholDecomp.getQuick(i, k) * this.gen.nextDouble();
            }
            obs[i] = x[i] + this.mu[i] * dt + Math.sqrt(dt) * z;
        }
        ++this.observationIndex;
        return obs;
    }

    @Override
    public double[] generatePath() {
        double[] u = new double[this.c * this.d];
        for (int i = 0; i < this.c * this.d; ++i) {
            u[i] = this.gen.nextDouble();
        }
        return this.generatePath(u);
    }

    public double[] generatePath(double[] uniform01) {
        if (!this.covZiSCholDecomp) {
            this.initCovZCholDecomp();
        }
        double[] QMCpointsPart = new double[this.c];
        for (int i = 0; i < this.c; ++i) {
            this.path[i] = this.x0[i];
        }
        for (int j = 0; j < this.d; ++j) {
            int i;
            for (i = 0; i < this.c; ++i) {
                QMCpointsPart[i] = uniform01[j * this.c + i];
            }
            for (i = 0; i < this.c; ++i) {
                double z = 0.0;
                for (int k = 0; k < this.c; ++k) {
                    z += this.covZCholDecomp.getQuick(i, k) * QMCpointsPart[k];
                }
                this.path[this.c * (j + 1) + i] = this.path[this.c * j + i] + this.mu[i] * this.dt[j] + this.sqrdt[j] * z;
            }
        }
        this.observationIndex = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath(RandomStream stream) {
        this.gen.setStream(stream);
        return this.generatePath();
    }

    public void setParams(int c, double[] x0, double[] mu, double[] sigma, double[][] corrZ) {
        this.c = c;
        this.x0 = x0;
        this.mu = mu;
        this.sigma = sigma;
        this.corrZ = corrZ;
        if (x0.length < c) {
            throw new IllegalArgumentException("x0 dimension :  " + x0.length + " is smaller than the process dimension : " + c);
        }
        if (mu.length < c) {
            throw new IllegalArgumentException("mu dimension :  " + mu.length + " is smaller than the process dimension : " + c);
        }
        if (sigma.length < c) {
            throw new IllegalArgumentException("sigma dimension :  " + sigma.length + " is smaller than the process dimension : " + c);
        }
        if (corrZ.length < c || corrZ[0].length < c) {
            throw new IllegalArgumentException("corrZ dimensions :  " + corrZ.length + "x" + corrZ[0].length + " are smaller than the process dimension : " + c);
        }
        this.covZ = new DenseDoubleMatrix2D(c, c);
        this.initCovZ();
        this.covZiSCholDecomp = false;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public void setParams(double[] x0, double[] mu, double[] sigma) {
        this.x0 = x0;
        this.mu = mu;
        this.sigma = sigma;
        this.covZ = new DenseDoubleMatrix2D(this.c, this.c);
        this.initCovZ();
        this.covZiSCholDecomp = false;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    @Override
    public void setStream(RandomStream stream) {
        this.gen.setStream(stream);
    }

    @Override
    public RandomStream getStream() {
        return this.gen.getStream();
    }

    public NormalGen getGen() {
        return this.gen;
    }

    @Override
    protected void init() {
        super.init();
        this.dt = new double[this.d + 1];
        this.sqrdt = new double[this.d + 1];
        for (int j = 0; j < this.d; ++j) {
            this.dt[j] = this.t[j + 1] - this.t[j];
            this.sqrdt[j] = Math.sqrt(this.dt[j]);
        }
    }

    protected void initCovZCholDecomp() {
        this.covZCholDecomp = new DenseDoubleMatrix2D(this.c, this.c);
        this.covZCholDecomp = DMatrix.CholeskyDecompose(this.covZ);
        this.covZiSCholDecomp = true;
    }

    protected void initCovZ() {
        for (int i = 0; i < this.c; ++i) {
            for (int j = 0; j < this.c; ++j) {
                this.covZ.setQuick(i, j, this.corrZ[i][j] * this.sigma[i] * this.sigma[j]);
            }
        }
    }

    public double[] getMu() {
        return this.mu;
    }
}

