/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

import umontreal.ssj.util.MultivariateFunction;

public class RatioFunction
implements MultivariateFunction {
    private double zeroOverZero = Double.NaN;

    public RatioFunction() {
    }

    public RatioFunction(double zeroOverZero) {
        this.zeroOverZero = zeroOverZero;
    }

    public double getZeroOverZeroValue() {
        return this.zeroOverZero;
    }

    public void setZeroOverZeroValue(double zeroOverZero) {
        this.zeroOverZero = zeroOverZero;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double evaluate(double ... x) {
        if (x.length != 2) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        if (x[0] == 0.0 && x[1] == 0.0) {
            return this.zeroOverZero;
        }
        return x[0] / x[1];
    }

    @Override
    public double evaluateGradient(int i, double ... x) {
        if (x.length != 2) {
            throw new IllegalArgumentException("Invalid length of x");
        }
        switch (i) {
            case 0: {
                return 1.0 / x[1];
            }
            case 1: {
                return -x[0] / (x[1] * x[1]);
            }
        }
        throw new IndexOutOfBoundsException("Invalid value of i: " + i);
    }
}

