/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util.sort;

public class HilbertCurveMap {
    int dimension;
    int m;
    int maxnbits;
    int maxlength;
    int[] p_to_s;
    int[] s_to_p;
    int[] p_to_J;
    int[] bit;
    int[] parity;
    int[][] circshift;
    int[][] bitof;

    void initTables() {
        int b;
        this.p_to_s = new int[this.maxlength];
        this.s_to_p = new int[this.maxlength];
        this.p_to_J = new int[this.maxlength];
        this.parity = new int[this.maxlength];
        this.bit = new int[this.maxnbits];
        this.circshift = new int[this.maxlength][this.maxnbits];
        this.bitof = new int[this.maxlength][this.maxnbits];
        int n = this.dimension;
        long two_n = 1 << n;
        for (b = 0; b < n; ++b) {
            this.bit[b] = 1 << n - b - 1;
        }
        int i = 0;
        while ((long)i < two_n) {
            for (b = 0; b < n; ++b) {
                this.bitof[i][b] = (i & this.bit[b]) != 0 ? 1 : 0;
            }
            ++i;
        }
        i = 0;
        while ((long)i < two_n) {
            for (b = 0; b < n; ++b) {
                this.circshift[i][b] = (int)((long)(i >> b) | (long)(i << n - b) & two_n - 1L);
            }
            ++i;
        }
        this.parity[0] = 0;
        i = 1;
        b = 1;
        while ((long)i < two_n) {
            if (i == b * 2) {
                b *= 2;
            }
            this.parity[i] = 1 - this.parity[i - b];
            ++i;
        }
        i = 0;
        while ((long)i < two_n) {
            int s = i & this.bit[0];
            for (b = 1; b < n; ++b) {
                if ((this.bitof[i][b] ^ this.bitof[i][b - 1]) == 0) continue;
                s |= this.bit[b];
            }
            this.p_to_s[i] = s;
            this.s_to_p[s] = i;
            this.p_to_J[i] = n - 1;
            for (b = 0; b < n; ++b) {
                if (this.bitof[i][b] == this.bitof[i][n - 1]) continue;
                this.p_to_J[i] = b;
            }
            ++i;
        }
    }

    public HilbertCurveMap(int d, int m) {
        this.dimension = d;
        this.m = m;
        this.maxnbits = m;
        this.maxlength = 1 << this.dimension;
        this.initTables();
    }

    public HilbertCurveMap(int d) {
        this(d, 63 / d);
    }

    public int dimension() {
        return this.dimension;
    }

    public int getM() {
        return this.m;
    }

    public void indexToCoordinates(long r, int[] a) {
        int i;
        int[] rho = new int[9];
        int tauT1 = 0;
        int omega1 = 0;
        int[] alpha = new int[9];
        int n = this.dimension;
        for (i = this.m - 1; i >= 0; --i) {
            rho[i] = (int)(r & (long)((1 << n) - 1));
            r >>= n;
        }
        int Jsum = 0;
        for (i = 0; i < this.m; ++i) {
            int tauT;
            int sigmaT;
            int rh = rho[i];
            int J = this.p_to_J[rh];
            int sigma = this.p_to_s[rh];
            int tau = sigma ^ 1;
            if (this.parity[tau] != 0) {
                tau ^= this.bit[J];
            }
            if (Jsum > 0) {
                sigmaT = this.circshift[sigma][Jsum];
                tauT = this.circshift[tau][Jsum];
            } else {
                sigmaT = sigma;
                tauT = tau;
            }
            if ((Jsum += J) >= n) {
                Jsum -= n;
            }
            int omega = i == 0 ? 0 : omega1 ^ tauT1;
            omega1 = omega;
            tauT1 = tauT;
            alpha[i] = omega ^ sigmaT;
        }
        for (int b = 0; b < n; ++b) {
            int ab = 0;
            int bt = this.bit[b];
            switch (this.m) {
                case 9: {
                    if ((alpha[8] & bt) != 0) {
                        ab |= 1;
                    }
                }
                case 8: {
                    if ((alpha[7] & bt) != 0) {
                        ab |= 2;
                    }
                }
                case 7: {
                    if ((alpha[6] & bt) != 0) {
                        ab |= 4;
                    }
                }
                case 6: {
                    if ((alpha[5] & bt) != 0) {
                        ab |= 8;
                    }
                }
                case 5: {
                    if ((alpha[4] & bt) != 0) {
                        ab |= 0x10;
                    }
                }
                case 4: {
                    if ((alpha[3] & bt) != 0) {
                        ab |= 0x20;
                    }
                }
                case 3: {
                    if ((alpha[2] & bt) != 0) {
                        ab |= 0x40;
                    }
                }
                case 2: {
                    if ((alpha[1] & bt) != 0) {
                        ab |= 0x80;
                    }
                }
                case 1: {
                    if ((alpha[0] & bt) == 0) break;
                    ab |= 0x100;
                }
            }
            a[b] = ab >> 9 - this.m;
        }
    }

    public long coordinatesToIndex(int[] a) {
        int i;
        int[] rho = new int[this.maxnbits];
        int[] alpha = new int[this.maxnbits];
        int tauT1 = 0;
        int omega1 = 0;
        int n = this.dimension;
        for (i = this.m; i > 0; --i) {
            alpha[i - 1] = 0;
        }
        for (int b = 0; b < n; ++b) {
            long bt = this.bit[b];
            long t = a[b];
            for (i = 1; i <= this.m; ++i) {
                if (t >> this.m - i == 0L) continue;
                int n2 = i - 1;
                alpha[n2] = (int)((long)alpha[n2] | bt);
                t -= (long)(1 << this.m - i);
            }
        }
        int Jsum = 0;
        for (i = 0; i < this.m; ++i) {
            int omega = i == 0 ? 0 : omega1 ^ tauT1;
            int sigmaT = alpha[i] ^ omega;
            int sigma = Jsum != 0 ? this.circshift[sigmaT][n - Jsum] : sigmaT;
            rho[i] = this.s_to_p[sigma];
            int J = this.p_to_J[rho[i]];
            int tau = sigma ^ 1;
            if (this.parity[tau] != 0) {
                tau ^= this.bit[J];
            }
            int tauT = Jsum != 0 ? this.circshift[tau][Jsum] : tau;
            if ((Jsum += J) >= n) {
                Jsum -= n;
            }
            tauT1 = tauT;
            omega1 = omega;
        }
        long rl = 0L;
        for (i = 0; i < this.m; ++i) {
            rl = rl << n | (long)rho[i];
        }
        return rl;
    }

    public void pointToCoordinates(double[] p, int[] a) {
        for (int j = 0; j < this.dimension; ++j) {
            a[j] = (int)(p[j] * (double)(1 << this.m));
        }
    }
}

