/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import java.util.Map;
import net.sf.json.JSONException;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class PropertySetStrategy {
    public static final PropertySetStrategy DEFAULT = new DefaultPropertySetStrategy();

    public abstract void setProperty(Object var1, String var2, Object var3) throws JSONException;

    private static final class DefaultPropertySetStrategy
    extends PropertySetStrategy {
        private DefaultPropertySetStrategy() {
        }

        public void setProperty(Object bean, String key, Object value) throws JSONException {
            if (bean instanceof Map) {
                ((Map)bean).put(key, value);
            } else {
                try {
                    PropertyUtils.setSimpleProperty(bean, key, value);
                }
                catch (Exception e) {
                    throw new JSONException(e);
                }
            }
        }
    }
}

