/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterShift
extends CharacterConverter12Byte {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    public final byte SHIFT_OUT = (byte)14;
    public final byte SHIFT_IN = (byte)15;

    public CharacterConverterShift() {
        this.m_groupId = 7;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    @Override
    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2 * 2];
        int n4 = 0;
        int n5 = n;
        int n6 = 15;
        while (n5 < n3) {
            int n7;
            int n8;
            if (byArray[n5] == 15) {
                n6 = 15;
                ++n5;
                continue;
            }
            if (byArray[n5] == 14) {
                n6 = 14;
                ++n5;
                continue;
            }
            if (n6 == 15) {
                n8 = byArray[n5] & 0xFF;
                n7 = this.toUnicode(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                ++n5;
                continue;
            }
            if (n5 < n3 - 1) {
                n8 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                n7 = this.toUnicode(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                n5 += 2;
                continue;
            }
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        return new String(cArray, 0, n4);
    }

    @Override
    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2 * 2];
        int n4 = 0;
        int n5 = n;
        int n6 = 15;
        while (n5 < n3) {
            int n7;
            int n8;
            if (byArray[n5] == 15) {
                n6 = 15;
                ++n5;
                continue;
            }
            if (byArray[n5] == 14) {
                n6 = 14;
                ++n5;
                continue;
            }
            if (n6 == 15) {
                n8 = byArray[n5] & 0xFF;
                n7 = this.toUnicodeWithReplacement(n8);
                if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                    cArray[n4++] = (char)(n7 >>> 16);
                    cArray[n4++] = (char)(n7 & 0xFFFF);
                } else {
                    cArray[n4++] = (char)n7;
                }
                ++n5;
                continue;
            }
            if (n5 >= n3 - 1) break;
            n8 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
            n7 = this.toUnicodeWithReplacement(n8);
            if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n7 >>> 16);
                cArray[n4++] = (char)(n7 & 0xFFFF);
            } else {
                cArray[n4++] = (char)n7;
            }
            n5 += 2;
        }
        return new String(cArray, 0, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 15;
        for (int i = 0; i < n; ++i) {
            char c;
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 >= n || cArray[i + 1] < '\udc00' || cArray[i + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                c = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                ++i;
            } else {
                c = this.toOracleCharacter(cArray[i], '\u0000');
            }
            int n4 = c & 0xFF00;
            if (n4 != 0) {
                if (n3 == 15) {
                    n3 = 14;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)c;
                continue;
            }
            if (n3 == 14) {
                n3 = 15;
                byArray[n2++] = 15;
            }
            byArray[n2++] = (byte)c;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 65535;
        int n3 = 0;
        int n4 = 15;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 < n && cArray[i + 1] >= '\udc00' && cArray[i + 1] <= '\udfff') {
                    n2 = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                    ++i;
                } else {
                    byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                    byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                }
            } else {
                n2 = this.toOracleCharacterWithReplacement(cArray[i], '\u0000');
            }
            int n5 = n2 & 0xFF00;
            if (n5 != 0) {
                if (n4 == 15) {
                    n4 = 14;
                    byArray[n3++] = 14;
                }
                byArray[n3++] = (byte)(n5 >> 8);
                byArray[n3++] = (byte)n2;
                continue;
            }
            if (n4 == 14) {
                n4 = 15;
                byArray[n3++] = 15;
            }
            byArray[n3++] = (byte)n2;
        }
        if (n4 == 14) {
            n4 = 15;
            byArray[n3++] = 15;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }
}

