/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.AbstractDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.util.StringUtils;

public class HikariDataSourceCreator
extends AbstractDataSourceCreator
implements DataSourceCreator {
    private static Boolean hikariExists = false;
    private HikariCpConfig hikariCpConfig;

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty, String publicKey) {
        if (StringUtils.isEmpty((Object)dataSourceProperty.getPublicKey())) {
            dataSourceProperty.setPublicKey(publicKey);
        }
        HikariConfig config = dataSourceProperty.getHikari().toHikariConfig(this.hikariCpConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        return new HikariDataSource(config);
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && hikariExists != false || type != null && "com.zaxxer.hikari.HikariDataSource".equals(type.getName());
    }

    public HikariCpConfig getHikariCpConfig() {
        return this.hikariCpConfig;
    }

    public void setHikariCpConfig(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariDataSourceCreator)) {
            return false;
        }
        HikariDataSourceCreator other = (HikariDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HikariCpConfig this$hikariCpConfig = this.getHikariCpConfig();
        HikariCpConfig other$hikariCpConfig = other.getHikariCpConfig();
        return !(this$hikariCpConfig == null ? other$hikariCpConfig != null : !((Object)this$hikariCpConfig).equals(other$hikariCpConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HikariCpConfig $hikariCpConfig = this.getHikariCpConfig();
        result = result * 59 + ($hikariCpConfig == null ? 43 : ((Object)$hikariCpConfig).hashCode());
        return result;
    }

    public String toString() {
        return "HikariDataSourceCreator(hikariCpConfig=" + this.getHikariCpConfig() + ")";
    }

    public HikariDataSourceCreator(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }

    static {
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            hikariExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

