/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import com.sforce.ws.SoapFaultException;
import com.sforce.ws.bind.TypeInfo;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.parser.PullParserException;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.parser.XmlOutputStream;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.Verbose;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class SoapConnection {
    private String url;
    private TypeMapper typeMapper;
    private String objectNamespace;
    private HashMap<QName, Object> headers = new HashMap();
    private ConnectorConfig config;
    private Object connection;
    private Map<QName, Class> knownHeaders;

    public SoapConnection(String url, String objectNamespace, TypeMapper typeMapper, ConnectorConfig config) {
        this.url = url;
        this.objectNamespace = objectNamespace;
        this.typeMapper = typeMapper;
        this.config = config;
    }

    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public void setKnownHeaders(Map<QName, Class> knownHeaders) {
        this.knownHeaders = knownHeaders;
    }

    public XMLizable send(QName requestElement, XMLizable request, QName responseElement, Class responseType) throws ConnectionException {
        return this.send(null, requestElement, request, responseElement, responseType);
    }

    public XMLizable send(String soapAction, QName requestElement, XMLizable request, QName responseElement, Class responseType) throws ConnectionException {
        long startTime = System.currentTimeMillis();
        try {
            boolean firstTime = true;
            while (true) {
                try {
                    Transport transport = this.newTransport(this.config);
                    OutputStream out = transport.connect(this.url, soapAction);
                    this.sendRequest(out, request, requestElement);
                    InputStream in = transport.getContent();
                    XMLizable result = this.receive(transport, responseElement, responseType, in);
                    return result;
                }
                catch (SessionTimedOutException se) {
                    if (this.config.getSessionRenewer() == null || !firstTime) {
                        throw (ConnectionException)se.getCause();
                    }
                    SessionRenewer.SessionRenewalHeader sessionHeader = this.config.getSessionRenewer().renewSession(this.config);
                    if (sessionHeader != null) {
                        this.addHeader(sessionHeader.name, sessionHeader.headerElement);
                    }
                    firstTime = false;
                    continue;
                }
                break;
            }
        }
        catch (SocketTimeoutException e) {
            long timeTaken = System.currentTimeMillis() - startTime;
            throw new ConnectionException("Request to " + this.url + " timed out. TimeTaken=" + timeTaken + " ConnectionTimeout=" + this.config.getConnectionTimeout() + " ReadTimeout=" + this.config.getReadTimeout(), e);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to send request to " + this.url, e);
        }
    }

    private Transport newTransport(ConnectorConfig config) throws ConnectionException {
        if (config.getTransportFactory() != null) {
            Transport t = config.getTransportFactory().createTransport();
            t.setConfig(config);
            return t;
        }
        try {
            Transport t = (Transport)config.getTransport().newInstance();
            t.setConfig(config);
            return t;
        }
        catch (InstantiationException e) {
            throw new ConnectionException("Failed to create new Transport " + config.getTransport());
        }
        catch (IllegalAccessException e) {
            throw new ConnectionException("Failed to create new Transport " + config.getTransport());
        }
    }

    private XMLizable receive(Transport transport, QName responseElement, Class responseType, InputStream in) throws IOException, ConnectionException {
        XMLizable result;
        block6: {
            try {
                XmlInputStream xin = new XmlInputStream();
                xin.setInput(in, "UTF-8");
                if (transport.isSuccessful()) {
                    result = this.bind(xin, responseElement, responseType);
                    break block6;
                }
                throw this.createException(xin);
            }
            catch (PullParserException e) {
                throw new ConnectionException("Failed to create/parse xml input stream ", e);
            }
            finally {
                in.close();
            }
        }
        return result;
    }

    private XMLizable bind(XmlInputStream xin, QName responseElement, Class responseType) throws IOException, ConnectionException {
        this.readSoapEnvelopeStart(xin);
        xin.peekTag();
        this.typeMapper.verifyTag(responseElement.getNamespaceURI(), responseElement.getLocalPart(), xin.getNamespace(), xin.getName());
        TypeInfo info = new TypeInfo(responseElement.getNamespaceURI(), responseElement.getLocalPart(), null, null, 1, 1, true);
        XMLizable result = (XMLizable)this.typeMapper.readObject(xin, info, responseType);
        this.readSoapEnvelopeEnd(xin);
        return result;
    }

    private ConnectionException createException(XmlInputStream xin) throws IOException, ConnectionException {
        this.readSoapEnvelopeStart(xin);
        xin.nextTag();
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Fault", xin.getNamespace(), xin.getName());
        xin.nextTag();
        if (!"faultcode".equals(xin.getName())) {
            throw new ConnectionException("Unable to find 'faultcode' in SOAP:Fault");
        }
        String faultCodeStr = xin.nextText();
        String prefix = TypeMapper.getPrefix(faultCodeStr);
        String name = TypeMapper.getType(faultCodeStr);
        String namespace = xin.getNamespace(prefix);
        QName faultCode = new QName(namespace, name);
        xin.nextTag();
        if (!"faultstring".equals(xin.getName())) {
            throw new ConnectionException("Unable to find 'faultstring' in SOAP:Fault");
        }
        String faultstring = xin.nextText();
        xin.peekTag();
        ConnectionException e = "detail".equals(xin.getName()) ? this.parseDetail(xin, faultCode, faultstring) : new SoapFaultException(faultCode, faultstring);
        xin.nextTag();
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Fault", xin.getNamespace(), xin.getName());
        this.readSoapEnvelopeEnd(xin);
        return e;
    }

    private ConnectionException parseDetail(XmlInputStream xin, QName faultCode, String faultstring) throws IOException, ConnectionException {
        ConnectionException e;
        xin.nextTag();
        xin.peekTag();
        if (xin.getEventType() == 3) {
            throw new SoapFaultException(faultCode, faultstring);
        }
        TypeInfo info = new TypeInfo(null, null, null, null, 1, 1, true);
        try {
            e = (ConnectionException)this.typeMapper.readObject(xin, info, ConnectionException.class);
            if (e instanceof SoapFaultException) {
                ((SoapFaultException)e).setFaultCode(faultCode);
                if (faultstring != null && (faultstring.contains("Session timed out") || faultstring.contains("Session not found") || faultstring.contains("Illegal Session")) && "INVALID_SESSION_ID".equals(faultCode.getLocalPart())) {
                    e = new SessionTimedOutException(faultstring, e);
                }
            }
        }
        catch (ConnectionException ce) {
            throw new ConnectionException("Failed to parse detail: " + xin + " due to: " + ce, ce.getCause());
        }
        xin.nextTag();
        if (!"detail".equals(xin.getName())) {
            throw new ConnectionException("Failed to find </detail>");
        }
        return e;
    }

    private void readSoapEnvelopeStart(XmlInputStream xin) throws IOException, ConnectionException {
        xin.nextTag();
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", xin.getNamespace(), xin.getName());
        xin.nextTag();
        if (this.isHeader(xin)) {
            this.readSoapHeader(xin);
            xin.nextTag();
        }
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Body", xin.getNamespace(), xin.getName());
    }

    private boolean isHeader(XmlInputStream xin) {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(xin.getNamespace()) && "Header".equals(xin.getName());
    }

    private void readSoapHeader(XmlInputStream xin) throws IOException, ConnectionException {
        do {
            Class headerType;
            xin.peekTag();
            if (xin.getEventType() != 2) continue;
            QName tag = new QName(xin.getNamespace(), xin.getName());
            Class clazz = headerType = this.knownHeaders != null ? this.knownHeaders.get(tag) : null;
            if (headerType == null) continue;
            TypeInfo info = new TypeInfo(xin.getNamespace(), xin.getName(), null, null, 1, 1, true);
            XMLizable result = (XMLizable)this.typeMapper.readObject(xin, info, headerType);
            if (this.connection == null) continue;
            this.setHeader(tag, headerType, result);
        } while (xin.getEventType() != 3 || !this.isHeader(xin));
        xin.next();
    }

    private void setHeader(QName tag, Class headerType, XMLizable result) {
        try {
            Method m = this.connection.getClass().getMethod("__set" + tag.getLocalPart(), headerType);
            m.invoke(this.connection, result);
        }
        catch (NoSuchMethodException e) {
            Verbose.log("Failed to set response header " + e);
        }
        catch (IllegalAccessException e) {
            Verbose.log("Failed to set response header " + e);
        }
        catch (InvocationTargetException e) {
            Verbose.log("Failed to set response header " + e);
        }
    }

    private void readSoapEnvelopeEnd(XmlInputStream xin) throws IOException, ConnectionException {
        xin.nextTag();
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Body", xin.getNamespace(), xin.getName());
        xin.nextTag();
        this.typeMapper.verifyTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope", xin.getNamespace(), xin.getName());
    }

    private void sendRequest(OutputStream out, XMLizable request, QName requestElement) throws IOException {
        XmlOutputStream xout = new XmlOutputStream(out, this.config.isPrettyPrintXml());
        xout.startDocument();
        xout.setPrefix("env", "http://schemas.xmlsoap.org/soap/envelope/");
        xout.setPrefix("xsd", "http://www.w3.org/2001/XMLSchema");
        xout.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xout.writeStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        if (this.headers.size() > 0) {
            this.writeHeaders(xout);
        }
        this.writeBody(xout, requestElement, request);
        xout.writeEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
        xout.endDocument();
        xout.close();
    }

    private void writeHeaders(XmlOutputStream xout) throws IOException {
        xout.writeStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        for (Map.Entry<QName, Object> entry : this.headers.entrySet()) {
            xout.setPrefix(null, entry.getKey().getNamespaceURI());
            Object value = entry.getValue();
            if (!(value instanceof XMLizable)) continue;
            ((XMLizable)value).write(entry.getKey(), xout, this.typeMapper);
        }
        xout.writeEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    }

    private void writeBody(XmlOutputStream xout, QName requestElement, XMLizable request) throws IOException {
        xout.writeStartTag("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        xout.setPrefix("m", requestElement.getNamespaceURI());
        if (this.objectNamespace != null) {
            xout.setPrefix("sobj", this.objectNamespace);
        }
        request.write(requestElement, xout, this.typeMapper);
        xout.writeEndTag("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    }

    public void addHeader(QName sessionHeader, Object header) {
        this.headers.put(sessionHeader, header);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    private static class SessionTimedOutException
    extends ConnectionException {
        private SessionTimedOutException(String faultString, Exception e) {
            super(faultString, e);
        }
    }
}

