/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.iharder.Base64;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestInvocation;

public final class HmacPostBodyDigest
implements ParamsDigest {
    private static final String HMAC_SHA_512 = "HmacSHA512";
    private final Mac mac;

    private HmacPostBodyDigest(String secretKeyBase64) throws IllegalArgumentException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(Base64.decode((byte[])secretKeyBase64.getBytes(StandardCharsets.UTF_8)), HMAC_SHA_512);
            this.mac = Mac.getInstance(HMAC_SHA_512);
            this.mac.init(secretKey);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not decode Base 64 string", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key for hmac initialization.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
    }

    public static HmacPostBodyDigest createInstance(String secretKeyBase64) throws IllegalArgumentException {
        return secretKeyBase64 == null ? null : new HmacPostBodyDigest(secretKeyBase64);
    }

    @Override
    public String digestParams(RestInvocation restInvocation) {
        this.mac.update(restInvocation.getRequestBody().getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBytes((byte[])this.mac.doFinal()).trim();
    }
}

