/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.AwareException;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.FormUrlEncodedRequestWriter;
import si.mazi.rescu.HttpResponseAware;
import si.mazi.rescu.HttpTemplate;
import si.mazi.rescu.InvocationAware;
import si.mazi.rescu.InvocationResult;
import si.mazi.rescu.RequestWriter;
import si.mazi.rescu.RequestWriterResolver;
import si.mazi.rescu.ResponseReaderResolver;
import si.mazi.rescu.RestInvocation;
import si.mazi.rescu.RestMethodMetadata;
import si.mazi.rescu.SynchronizedValueFactory;
import si.mazi.rescu.serialization.PlainTextResponseReader;
import si.mazi.rescu.serialization.ToStringRequestWriter;
import si.mazi.rescu.serialization.jackson.DefaultJacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonRequestWriter;
import si.mazi.rescu.serialization.jackson.JacksonResponseReader;

public class RestInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RestInvocationHandler.class);
    private final ResponseReaderResolver responseReaderResolver;
    private final RequestWriterResolver requestWriterResolver;
    private final HttpTemplate httpTemplate;
    private final String intfacePath;
    private final String baseUrl;
    private final ClientConfig config;
    private final Map<Method, RestMethodMetadata> methodMetadataCache = new HashMap<Method, RestMethodMetadata>();

    RestInvocationHandler(Class<?> restInterface, String url, ClientConfig config) {
        this.intfacePath = restInterface.getAnnotation(Path.class).value();
        this.baseUrl = url;
        if (config == null) {
            config = new ClientConfig();
        }
        this.config = config;
        JacksonObjectMapperFactory mapperFactory = config.getJacksonObjectMapperFactory();
        if (mapperFactory == null) {
            mapperFactory = new DefaultJacksonObjectMapperFactory();
        }
        ObjectMapper mapper = mapperFactory.createObjectMapper();
        this.requestWriterResolver = new RequestWriterResolver();
        this.requestWriterResolver.addWriter("application/x-www-form-urlencoded", new FormUrlEncodedRequestWriter());
        this.requestWriterResolver.addWriter("application/json", new JacksonRequestWriter(mapper));
        this.requestWriterResolver.addWriter("text/plain", new ToStringRequestWriter());
        this.responseReaderResolver = new ResponseReaderResolver();
        this.responseReaderResolver.addReader("application/json", new JacksonResponseReader(mapper, this.config.isIgnoreHttpErrorCodes()));
        this.responseReaderResolver.addReader("text/plain", new PlainTextResponseReader(this.config.isIgnoreHttpErrorCodes()));
        this.httpTemplate = new HttpTemplate(this.config.getHttpConnTimeout(), this.config.getHttpReadTimeout(), this.config.getProxyHost(), this.config.getProxyPort(), this.config.getSslSocketFactory(), this.config.getHostnameVerifier(), this.config.getOAuthConsumer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        RestMethodMetadata methodMetadata = this.getMetadata(method);
        HttpURLConnection connection = null;
        RestInvocation invocation = null;
        Object lock = RestInvocationHandler.getValueGenerator(args);
        if (lock == null) {
            lock = new Object();
        }
        try {
            SynchronizedValueFactory synchronizedValueFactory = lock;
            synchronized (synchronizedValueFactory) {
                invocation = RestInvocation.create(this.requestWriterResolver, methodMetadata, args, this.config.getDefaultParamsMap());
                connection = this.invokeHttp(invocation);
            }
            return this.receiveAndMap(methodMetadata, connection);
        }
        catch (Exception e) {
            boolean shouldWrap = this.config.isWrapUnexpectedExceptions();
            if (e instanceof InvocationAware) {
                try {
                    ((InvocationAware)((Object)e)).setInvocation(invocation);
                    shouldWrap = false;
                }
                catch (Exception ex) {
                    log.warn("Failed to set invocation on the InvocationAware", (Throwable)ex);
                }
            }
            if (e instanceof HttpResponseAware && connection != null) {
                try {
                    ((HttpResponseAware)((Object)e)).setResponseHeaders(connection.getHeaderFields());
                    shouldWrap = false;
                }
                catch (Exception ex) {
                    log.warn("Failed to set response headers on the HttpReponseAware", (Throwable)ex);
                }
            }
            if (shouldWrap) {
                throw new AwareException(e, invocation);
            }
            throw e;
        }
    }

    protected HttpURLConnection invokeHttp(RestInvocation invocation) throws IOException {
        RestMethodMetadata methodMetadata = invocation.getMethodMetadata();
        RequestWriter requestWriter = this.requestWriterResolver.resolveWriter(invocation.getMethodMetadata());
        String requestBody = requestWriter.writeBody(invocation);
        return this.httpTemplate.send(invocation.getInvocationUrl(), requestBody, invocation.getAllHttpHeaders(), methodMetadata.getHttpMethod());
    }

    protected Object receiveAndMap(RestMethodMetadata methodMetadata, HttpURLConnection connection) throws IOException {
        InvocationResult invocationResult = this.httpTemplate.receive(connection);
        return this.mapInvocationResult(invocationResult, methodMetadata);
    }

    private static SynchronizedValueFactory getValueGenerator(Object[] args) {
        if (args != null) {
            for (Object arg : args) {
                if (!(arg instanceof SynchronizedValueFactory)) continue;
                return (SynchronizedValueFactory)arg;
            }
        }
        return null;
    }

    protected Object mapInvocationResult(InvocationResult invocationResult, RestMethodMetadata methodMetadata) throws IOException {
        return this.responseReaderResolver.resolveReader(methodMetadata).read(invocationResult, methodMetadata);
    }

    private RestMethodMetadata getMetadata(Method method) {
        RestMethodMetadata metadata = this.methodMetadataCache.get(method);
        if (metadata == null) {
            metadata = RestMethodMetadata.create(method, this.baseUrl, this.intfacePath);
            this.methodMetadataCache.put(method, metadata);
        }
        return metadata;
    }
}

