/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Preconditions;

public class RequestSpec {
    private final RequestMethod method;
    private final String path;

    public RequestSpec(RequestMethod method, String path) {
        Preconditions.checkNotNull((Object)((Object)method));
        Preconditions.checkNotNull((Object)path);
        this.method = method;
        this.path = path;
    }

    public static RequestSpec requestSpec(RequestMethod method, String path) {
        return new RequestSpec(method, path);
    }

    public RequestMethod method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSpec that = (RequestSpec)o;
        if (this.method != that.method) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

