/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatFloatPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.FloatFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.MutableFloatIterator;
import com.gs.collections.api.map.primitive.FloatFloatMap;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.map.primitive.MutableFloatFloatMap;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.tuple.primitive.FloatFloatPair;
import com.gs.collections.impl.SpreadFunctions;
import com.gs.collections.impl.factory.primitive.FloatFloatMaps;
import com.gs.collections.impl.iterator.UnmodifiableFloatIterator;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableFloatKeySet;
import com.gs.collections.impl.map.mutable.primitive.AbstractMutableFloatValuesMap;
import com.gs.collections.impl.map.mutable.primitive.ImmutableFloatFloatMapKeySet;
import com.gs.collections.impl.map.mutable.primitive.MutableFloatKeysMap;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatFloatMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatFloatMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatFloatHashMap
extends AbstractMutableFloatValuesMap
implements MutableFloatFloatMap,
Externalizable,
MutableFloatKeysMap {
    private static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keysValues;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableFloatValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public FloatFloatHashMap() {
        this.allocateTable(16);
    }

    public FloatFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public FloatFloatHashMap(FloatFloatMap map) {
        if (map instanceof FloatFloatHashMap && ((FloatFloatHashMap)map).occupiedWithSentinels == 0) {
            FloatFloatHashMap hashMap = (FloatFloatHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keysValues = Arrays.copyOf(hashMap.keysValues, hashMap.keysValues.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1) {
        return new FloatFloatHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2) {
        return new FloatFloatHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2, float key3, float value3) {
        return new FloatFloatHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatFloatHashMap newWithKeysValues(float key1, float value1, float key2, float value2, float key3, float value3, float key4, float value4) {
        return new FloatFloatHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableFloatValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected float getEmptyValue() {
        return 0.0f;
    }

    @Override
    protected int getTableSize() {
        return this.keysValues.length / 2;
    }

    @Override
    protected float getValueAtIndex(int index) {
        return this.keysValues[index * 2 + 1];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatFloatMap)) {
            return false;
        }
        FloatFloatMap other = (FloatFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || Float.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0f)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || Float.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0f)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            float key = this.keysValues[i];
            if (!FloatFloatHashMap.isNonSentinel(key) || other.containsKey(key) && Float.compare(this.keysValues[i + 1], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ Float.floatToIntBits(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ Float.floatToIntBits(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i])) continue;
            result += Float.floatToIntBits(this.keysValues[i]) ^ Float.floatToIntBits(this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0f).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0f).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            float key = this.keysValues[i];
            if (!FloatFloatHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.keysValues[i + 1]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableFloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i])) continue;
            result = function.valueOf(result, this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keysValues, 0.0f);
    }

    public void put(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        float keyAtIndex = this.keysValues[index];
        if (Float.compare(keyAtIndex, key) == 0) {
            this.keysValues[index + 1] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(float value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(float value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(FloatFloatMap map) {
        map.forEachKeyValue(new FloatFloatProcedure(){

            public void value(float key, float value) {
                FloatFloatHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            float oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            float oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            float oldValue = this.keysValues[index + 1];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(float key, float value) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPut(float key, FloatFunction0 function) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        float value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> float getIfAbsentPutWith(float key, FloatFunction<? super P> function, P parameter) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.floatValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.floatValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        float value = function.floatValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPutWithKey(float key, FloatToFloatFunction function) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        float value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float addToValue(float key, float toBeAdded) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            int n = index + 1;
            this.keysValues[n] = this.keysValues[n] + toBeAdded;
            return this.keysValues[index + 1];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.keysValues[index + 1];
    }

    private void addKeyValueAtIndex(float key, float value, int index) {
        if (Float.compare(this.keysValues[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = key;
        this.keysValues[index + 1] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keysValues[index] = 1.0f;
        this.keysValues[index + 1] = 0.0f;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        float[] copy = new float[this.keysValues.length];
        System.arraycopy(this.keysValues, 0, copy, 0, this.keysValues.length);
        this.keysValues = copy;
        this.copyKeysOnWrite = false;
    }

    public float updateValue(float key, float initialValueIfAbsent, FloatToFloatFunction function) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableFloatValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            this.keysValues[index + 1] = function.valueOf(this.keysValues[index + 1]);
            return this.keysValues[index + 1];
        }
        float value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public FloatFloatHashMap withKeyValue(float key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2, float key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatFloatHashMap withKeysValues(float key1, float value1, float key2, float value2, float key3, float value3, float key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatFloatHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatFloatHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatFloatHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableFloatFloatMap asUnmodifiable() {
        return new UnmodifiableFloatFloatMap(this);
    }

    public MutableFloatFloatMap asSynchronized() {
        return new SynchronizedFloatFloatMap(this);
    }

    public ImmutableFloatFloatMap toImmutable() {
        return FloatFloatMaps.immutable.ofAll((FloatFloatMap)this);
    }

    public float get(float key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(float key, float ifAbsent) {
        if (FloatFloatHashMap.isEmptyKey(key) || FloatFloatHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private float getForSentinel(float key, float ifAbsent) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private float slowGetIfAbsent(float key, float ifAbsent) {
        int index = this.probe(key);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    private float fastGetIfAbsent(float key, float ifAbsent) {
        int index = this.mask((int)key) << 1;
        for (int i = 0; i < 8; i += 2) {
            float keyAtIndex = this.keysValues[index];
            if (Float.compare(keyAtIndex, key) == 0) {
                return this.keysValues[index + 1];
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return ifAbsent;
            }
            index = index + 2 & this.keysValues.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private float slowGetIfAbsentTwo(float key, float ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Float.compare(this.keysValues[index], key) == 0) {
            return this.keysValues[index + 1];
        }
        return ifAbsent;
    }

    public float getOrThrow(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatFloatHashMap.isNonSentinel(this.keysValues[index])) {
            return this.keysValues[index + 1];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(float key) {
        if (FloatFloatHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatFloatHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keysValues[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i]);
        }
    }

    public void forEachKeyValue(FloatFloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i])) continue;
            procedure.value(this.keysValues[i], this.keysValues[i + 1]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public RichIterable<FloatFloatPair> keyValuesView() {
        return new KeyValuesView();
    }

    public FloatFloatHashMap select(FloatFloatPredicate predicate) {
        FloatFloatHashMap result = new FloatFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    public FloatFloatHashMap reject(FloatFloatPredicate predicate) {
        FloatFloatHashMap result = new FloatFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i], this.keysValues[i + 1])) continue;
            result.put(this.keysValues[i], this.keysValues[i + 1]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeFloat(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeFloat(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(this.keysValues[i])) continue;
            out.writeFloat(this.keysValues[i]);
            out.writeFloat(this.keysValues[i + 1]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readFloat());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keysValues.length);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keysValues.length;
        float[] old = this.keysValues;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; i += 2) {
            if (!FloatFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], old[i + 1]);
        }
    }

    int probe(float element) {
        int index = this.mask((int)element) << 1;
        float keyAtIndex = this.keysValues[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        for (int i = 2; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(float element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 8; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            float keyAtIndex = this.keysValues[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(float element, int removedIndex) {
        int nextIndex = SpreadFunctions.floatSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
        float keyAtIndex;
        while (Float.compare(keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1], element) != 0) {
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(float element) {
        int code = SpreadFunctions.floatSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(float element) {
        int code = SpreadFunctions.floatSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keysValues = new float[sizeToAllocate << 1];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatFloatHashMap.isEmptyKey(key) && !FloatFloatHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !FloatFloatHashMap.isEmptyKey(this.keysValues[index * 2]) && !FloatFloatHashMap.isRemovedKey(this.keysValues[index * 2]);
    }

    private int maxOccupiedWithData() {
        return this.keysValues.length >> 2;
    }

    private int maxOccupiedWithSentinels() {
        return this.keysValues.length >> 3;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ float[] access$302(FloatFloatHashMap x0, float[] x1) {
        x0.keysValues = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<FloatFloatPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super FloatFloatPair> procedure) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.zeroValue));
                }
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keysValues.length; i += 2) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatFloatHashMap.this.keysValues[i], FloatFloatHashMap.this.keysValues[i + 1]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super FloatFloatPair> objectIntProcedure) {
            int index = 0;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keysValues.length; i += 2) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keysValues[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(FloatFloatHashMap.this.keysValues[i], FloatFloatHashMap.this.keysValues[i + 1]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super FloatFloatPair, ? super P> procedure, P parameter) {
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keysValues.length; i += 2) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keysValues[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(FloatFloatHashMap.this.keysValues[i], FloatFloatHashMap.this.keysValues[i + 1]), parameter);
            }
        }

        public Iterator<FloatFloatPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<FloatFloatPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public FloatFloatPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (FloatFloatHashMap.this.containsKey(0.0f)) {
                        return PrimitiveTuples.pair(0.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (FloatFloatHashMap.this.containsKey(1.0f)) {
                        return PrimitiveTuples.pair(1.0f, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.oneValue);
                    }
                }
                float[] keys = FloatFloatHashMap.this.keysValues;
                while (!FloatFloatHashMap.isNonSentinel(keys[this.position])) {
                    this.position += 2;
                }
                FloatFloatPair result = PrimitiveTuples.pair(keys[this.position], FloatFloatHashMap.this.keysValues[this.position + 1]);
                this.position += 2;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != FloatFloatHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableFloatValuesMap.AbstractFloatValuesCollection {
        private ValuesCollection() {
        }

        public MutableFloatIterator floatIterator() {
            return FloatFloatHashMap.this.floatIterator();
        }

        public boolean remove(float item) {
            int oldSize = FloatFloatHashMap.this.size();
            if (FloatFloatHashMap.this.sentinelValues != null) {
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsZeroKey && Float.compare(item, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.zeroValue) == 0) {
                    FloatFloatHashMap.this.removeKey(0.0f);
                }
                if (((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsOneKey && Float.compare(item, ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.oneValue) == 0) {
                    FloatFloatHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatFloatHashMap.this.keysValues.length; i += 2) {
                if (!FloatFloatHashMap.isNonSentinel(FloatFloatHashMap.this.keysValues[i]) || Float.compare(item, FloatFloatHashMap.this.keysValues[i + 1]) != 0) continue;
                FloatFloatHashMap.this.removeKey(FloatFloatHashMap.this.keysValues[i]);
            }
            return oldSize != FloatFloatHashMap.this.size();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = FloatFloatHashMap.this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            FloatFloatHashMap retained = FloatFloatHashMap.this.select(new FloatFloatPredicate((FloatSet)sourceSet){
                final /* synthetic */ FloatSet val$sourceSet;
                {
                    this.val$sourceSet = floatSet;
                }

                public boolean accept(float key, float value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                FloatFloatHashMap.access$302(FloatFloatHashMap.this, retained.keysValues);
                FloatFloatHashMap.this.sentinelValues = retained.sentinelValues;
                FloatFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableFloatKeySet {
        private KeySet() {
        }

        protected MutableFloatKeysMap getOuter() {
            return FloatFloatHashMap.this;
        }

        protected AbstractMutableFloatValuesMap.SentinelValues getSentinelValues() {
            return FloatFloatHashMap.this.sentinelValues;
        }

        protected float getKeyAtIndex(int index) {
            return FloatFloatHashMap.this.keysValues[index * 2];
        }

        protected int getTableSize() {
            return FloatFloatHashMap.this.keysValues.length / 2;
        }

        public MutableFloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = FloatFloatHashMap.this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            FloatFloatHashMap retained = FloatFloatHashMap.this.select(new FloatFloatPredicate((FloatSet)sourceSet){
                final /* synthetic */ FloatSet val$sourceSet;
                {
                    this.val$sourceSet = floatSet;
                }

                public boolean accept(float key, float value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                FloatFloatHashMap.access$302(FloatFloatHashMap.this, retained.keysValues);
                FloatFloatHashMap.this.sentinelValues = retained.sentinelValues;
                FloatFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                FloatFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(float ... source) {
            return this.retainAll(FloatHashSet.newSetWith(source));
        }

        public FloatSet freeze() {
            FloatFloatHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (FloatFloatHashMap.this.sentinelValues != null) {
                containsZeroKey = ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((FloatFloatHashMap)FloatFloatHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableFloatFloatMapKeySet(FloatFloatHashMap.this.keysValues, FloatFloatHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableFloatIterator {
        private int count;
        private int position;
        private float lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatFloatHashMap.this.containsKey(0.0f)) {
                    this.lastKey = 0.0f;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatFloatHashMap.this.containsKey(1.0f)) {
                    this.lastKey = 1.0f;
                    return this.lastKey;
                }
            }
            float[] keys = FloatFloatHashMap.this.keysValues;
            while (!FloatFloatHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            this.position += 2;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            FloatFloatHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyFloatIterable {
        private KeysView() {
        }

        public FloatIterator floatIterator() {
            return new UnmodifiableFloatIterator((FloatIterator)new KeySetIterator());
        }

        public void forEach(FloatProcedure procedure) {
            FloatFloatHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalFloatIterator
    implements MutableFloatIterator {
        private int count;
        private int position;
        private float lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatFloatHashMap.this.containsKey(0.0f)) {
                    this.lastKey = 0.0f;
                    return FloatFloatHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatFloatHashMap.this.containsKey(1.0f)) {
                    this.lastKey = 1.0f;
                    return FloatFloatHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatFloatHashMap.this.keysValues;
            while (!FloatFloatHashMap.isNonSentinel(keys[this.position])) {
                this.position += 2;
            }
            this.lastKey = keys[this.position];
            float result = FloatFloatHashMap.this.keysValues[this.position + 1];
            this.position += 2;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            FloatFloatHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

