/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableLongSetFactory;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableLongEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableLongSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;

public class ImmutableLongSetFactoryImpl
implements ImmutableLongSetFactory {
    public ImmutableLongSet empty() {
        return ImmutableLongEmptySet.INSTANCE;
    }

    public ImmutableLongSet of() {
        return this.empty();
    }

    public ImmutableLongSet with() {
        return this.empty();
    }

    public ImmutableLongSet of(long one) {
        return this.with(one);
    }

    public ImmutableLongSet with(long one) {
        return new ImmutableLongSingletonSet(one);
    }

    public ImmutableLongSet of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongSet with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return LongHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableLongSet ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongSet withAll(LongIterable items) {
        if (items instanceof ImmutableLongSet) {
            return (ImmutableLongSet)items;
        }
        return this.with(items.toArray());
    }
}

