/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.DoubleStack;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.DoubleStacks;
import com.gs.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleEmptyStack
implements ImmutableDoubleStack,
Serializable {
    static final ImmutableDoubleStack INSTANCE = new ImmutableDoubleEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public double peek() {
        throw new EmptyStackException();
    }

    public DoubleList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        throw new EmptyStackException();
    }

    public double peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return this;
    }

    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return this;
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public double sum() {
        return 0.0;
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public double[] toArray() {
        return new double[0];
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    public ImmutableDoubleStack push(double element) {
        return DoubleStacks.immutable.with(element);
    }

    public ImmutableDoubleStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableDoubleStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

