/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJideSplitButtonUI
extends VsnetMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    protected boolean _isFloatingIcon = false;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    public static ComponentUI createUI(JComponent x) {
        return new BasicJideSplitButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
        this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
        this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent e) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI ui, Class clazz) {
        if (clazz.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c) {
        BasicJideSplitButtonUI ui;
        if (condition == 0 && (ui = (BasicJideSplitButtonUI)BasicJideSplitButtonUI.getUIOfType(((JideSplitButton)c).getUI(), BasicJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem b = this.menuItem;
        LazyActionMap.installLazyActionMap(b, BasicJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap km = this.getInputMap(0, b);
        SwingUtilities.replaceUIInputMap(b, 0, km);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem b = this.menuItem;
        SwingUtilities.replaceUIInputMap(b, 2, null);
        SwingUtilities.replaceUIInputMap(b, 0, null);
        SwingUtilities.replaceUIActionMap(b, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        JideSplitButton b;
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        orientation = 0;
        Object o = menuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean paintBackground = o instanceof Boolean ? ((Boolean)o).booleanValue() : menuItem.isOpaque();
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g, menuItem, bgColor);
            if (menuItem.isEnabled()) {
                if (model.isArmed() || model.isPressed() || this.isMouseOver()) {
                    g.setColor(this.selectionForeground);
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.selectionForeground, menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                } else {
                    g.setColor(this.getForegroundOfState(menuItem));
                    g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                }
            } else {
                g.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlDkShadow"), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
            }
            return;
        }
        if (paintBackground) {
            if (menuItem.getParent() != null) {
                g.setColor(menuItem.getParent().getBackground());
            } else {
                g.setColor(menuItem.getBackground());
            }
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        if ((b = (JideSplitButton)menuItem).getButtonStyle() == 0) {
            if (model.isSelected()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                } else if (b.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
                }
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 4);
                    }
                } else {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 5);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                }
            } else if (paintBackground) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled() && b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                if (b.isEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b, g, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g, rect, 0);
                }
            }
        } else if (b.getButtonStyle() == 2) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunkenBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g, rect);
                    }
                }
            } else if ((b.isRolloverEnabled() && this.isMouseOver() || b.hasFocus()) && model.isEnabled()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g, rect, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(b)) {
                    rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                } else {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            }
        } else if (b.getButtonStyle() == 1) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b, g, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                if (!b.isOpaque()) {
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintSunken2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if (this.isMouseOver() && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 1);
                    }
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b.isOpaque()) {
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                    }
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 3);
                    if (!b.isOpaque()) {
                        rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g, rect);
                        rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g, rect);
                    }
                }
            } else if (b.isRolloverEnabled() && this.isMouseOver() && model.isEnabled()) {
                if (this.isAlwaysDropdown(b)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    this.paintRaised2Border(g, rect);
                } else {
                    Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    if (b.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    }
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 2);
                    rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                    rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g, rect);
                }
            } else if (b.isOpaque()) {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                if (b.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b, g, rect, orientation, 0);
            } else if (this.isAlwaysDropdown(b)) {
                Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            } else {
                Rectangle rect = this.getButtonRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
                rect = this.getDropDownRect(b, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g, rect);
            }
        }
        this.paintArrow(menuItem, g);
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g) {
        int menuHeight;
        int menuWidth;
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        int startX = menuItem.getComponentOrientation().isLeftToRight() ? menuWidth - 9 : 4;
        if (menuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(g, this.getForegroundOfState(menuItem), startX, menuHeight / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("controlShadow"), startX, menuHeight / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getDropDownRect(JComponent c, int orientation, int width, int height) {
        Object position = c.getClientProperty("JButton.segmentPosition");
        Rectangle rect = c.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), height) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), height);
        if (position != null && !"only".equals(position)) {
            if ("first".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("middle".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("last".equals(position)) {
                // empty if block
            }
        }
        return rect;
    }

    protected Rectangle getButtonRect(JComponent c, int orientation, int width, int height) {
        Rectangle rect = orientation == 0 && c.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin, height);
        return rect;
    }

    protected void paintSunkenBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintSunken2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y, b.x + b.width - 2, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 2);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + 1, b.x + b.width - 3, b.y + 1);
        g.drawLine(b.x + 1, b.y + 1, b.x + 1, b.y + b.height - 3);
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.x, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintRaised2Border(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x + 1, b.y + b.height - 2, b.x + b.width - 2, b.y + b.height - 2);
        g.drawLine(b.x + b.width - 2, 1, b.x + b.width - 2, b.y + b.height - 2);
        g.setColor(this._darkShadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    protected void paintRaisedBorder(Graphics g, Rectangle b) {
        Color old = g.getColor();
        g.setColor(this._lightHighlightColor);
        g.drawLine(b.x, b.y, b.x + b.width - 1, b.y);
        g.drawLine(b.x, b.y, b.x, b.y + b.height - 1);
        g.setColor(this._shadowColor);
        g.drawLine(b.x, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
        g.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y + b.height - 1);
        g.setColor(old);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getPreferredSize(c);
        }
        AbstractButton b = (AbstractButton)c;
        boolean isHorizontal = JideSwingUtilities.getOrientationOf(c) == 0;
        Dimension d = JideSwingUtilities.getPreferredButtonSize(b, this.defaultTextIconGap, true);
        if (BasicJideButtonUI.shouldWrapText(c)) {
            if (c instanceof JideSplitButton) {
                d.width += BasicJideSplitButtonUI.getAdjustExtraWidth(b, b.getText(), 8);
            }
        } else {
            d.width += this.getRightMargin();
            if (this.isDownArrowVisible(b.getParent())) {
                ++d.width;
            }
        }
        if (isHorizontal) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMinimumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            } else {
                d.height = (int)((float)d.height - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
            }
        }
        return d;
    }

    public Dimension getMaximumSize(JComponent c) {
        if (!(c instanceof JMenu) || !((JMenu)c).isTopLevelMenu()) {
            return super.getMaximumSize(c);
        }
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            if (JideSwingUtilities.getOrientationOf(c) == 0) {
                d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
            } else {
                d.height = (int)((float)d.height + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
            }
        }
        return d;
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!(menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu() || !menuItem.getComponentOrientation().isLeftToRight())) {
            int defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            int defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            textRect.x = defaultShadowWidth + defaultTextIconGap;
        }
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        Color oldColor = g.getColor();
        if (!model.isEnabled() || menuItem instanceof JideSplitButton && !((JideSplitButton)menuItem).isButtonEnabled()) {
            if (menuItem.getParent() != null) {
                g.setColor(menuItem.getParent().getBackground().brighter());
                this.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getParent().getBackground().darker());
            }
            this.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        } else {
            Color color = this.getForegroundOfState(menuItem);
            if (color == null || color instanceof UIResource) {
                if (model.isSelected()) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(color);
                }
            } else {
                g.setColor(color);
            }
            this.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
        g.setColor(oldColor);
    }

    private Color getForegroundOfState(JMenuItem menuItem) {
        int state = JideSwingUtilities.getButtonState(menuItem);
        Color foreground = null;
        if (menuItem instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)menuItem)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = menuItem.getForeground();
        }
        return foreground;
    }

    protected void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        JideSwingUtilities.drawStringUnderlineCharAt(c, g, text, underlinedIndex, x, y);
    }

    protected void paintIcon(JMenuItem b, Graphics g) {
        Icon icon;
        ButtonModel model = b.getModel();
        if (b.getIcon() != null && (icon = this.getIcon(b)) != null) {
            boolean enabled;
            boolean bl = enabled = model.isEnabled() && (!(model instanceof SplitButtonModel) || ((SplitButtonModel)model).isButtonEnabled());
            if (this.isFloatingIcon() && enabled) {
                if (model.isRollover() && !model.isPressed() && !model.isSelected()) {
                    if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon shadow = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            shadow.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        } else {
                            ImageIcon shadow = IconsFactory.createGrayImage(b, icon);
                            shadow.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        }
                        icon.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x - 1, BasicJideSplitButtonUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                }
            } else {
                icon.paintIcon(b, g, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
            }
        }
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected Icon getIcon(AbstractButton b) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (!model.isEnabled() || !((JideSplitButton)this.menuItem).isButtonEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            if (tmpIcon == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b, icon);
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                // empty if block
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        return icon;
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem menuItem) {
        return menuItem instanceof JideSplitButton && ((JideSplitButton)menuItem).isAlwaysDropdown();
    }

    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("downPressed"));
        map.put(new Actions("downReleased"));
    }

    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int mnemonic = this.menuItem.getModel().getMnemonic();
        if (mnemonic != 0 && this.windowInputMap != null) {
            int[] shortcutKeys = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (shortcutKeys == null) {
                shortcutKeys = new int[]{8};
            }
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu menu) {
        MenuElement[] selectedPath;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        if (menu.isTopLevelMenu()) {
            if (menu.isSelected()) {
                manager.clearSelectedPath();
            } else {
                Container cnt = BasicJideSplitButtonUI.getFirstParentMenuElement(menu);
                if (cnt != null && cnt instanceof MenuElement) {
                    ArrayList<Container> parents = new ArrayList<Container>();
                    while (cnt instanceof MenuElement) {
                        parents.add(0, cnt);
                        if (cnt instanceof JPopupMenu) {
                            cnt = (Container)((JPopupMenu)cnt).getInvoker();
                            continue;
                        }
                        cnt = BasicJideSplitButtonUI.getFirstParentMenuElement(cnt);
                    }
                    MenuElement[] me = new MenuElement[parents.size() + 1];
                    for (int i = 0; i < parents.size(); ++i) {
                        Container container = (Container)parents.get(i);
                        me[i] = (MenuElement)((Object)container);
                    }
                    me[parents.size()] = menu;
                    manager.setSelectedPath(me);
                } else {
                    MenuElement[] me = new MenuElement[]{menu};
                    manager.setSelectedPath(me);
                }
            }
        }
        if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
            if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                BasicJideSplitButtonUI.appendPath(selectedPath, menu.getPopupMenu());
            } else {
                BasicJideSplitButtonUI.setupPostTimer(menu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MenuElement)) continue;
            return parent;
        }
        return null;
    }

    public static int getAdjustExtraWidth(Component c, String text, int extraWidth) {
        String[] lines = BasicJideSplitButtonUI.getWrappedText(text);
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        int line1Width = fm.stringWidth(lines[0]);
        int line2Width = lines.length <= 1 ? 0 : fm.stringWidth(lines[1]);
        int oldMaxWidth = Math.max(line1Width, line2Width);
        int maxWidth = Math.max(line1Width, line2Width += extraWidth);
        return maxWidth - oldMaxWidth;
    }

    public static String getMaxLengthWord(String text) {
        if (text.indexOf(32) == -1) {
            return text;
        }
        int minDiff = text.length();
        int minPos = -1;
        int mid = text.length() / 2;
        int pos = -1;
        while ((pos = text.indexOf(32, pos + 1)) != -1) {
            int diff = Math.abs(pos - mid);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minPos = pos;
        }
        return minPos >= mid ? text.substring(0, minPos) : text.substring(minPos + 1);
    }

    public static String[] getWrappedText(String text) {
        String[] words = text.split(" ");
        if (words.length <= 2) {
            return words;
        }
        if (words.length >= 3) {
            int minDiff = text.length();
            int minPos = -1;
            int pos = -1;
            int mid = text.length() / 2;
            while ((pos = text.indexOf(32, pos + 1)) != -1) {
                int diff = Math.abs(pos - mid);
                if (diff >= minDiff) continue;
                minDiff = diff;
                minPos = pos;
            }
            return new String[]{text.substring(0, minPos), text.substring(minPos + 1)};
        }
        return words;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            String key = this.getName();
            if (PRESS.equals(key) && ((JideSplitButton)b).isAlwaysDropdown()) {
                key = DOWN_PRESS;
            }
            if (PRESS.equals(key)) {
                ButtonModel model = b.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b.hasFocus()) {
                    b.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else if (DOWN_PRESS.equals(key)) {
                BasicJideSplitButtonUI.downButtonPressed((JMenu)b);
            } else if (DOWN_RELEASE.equals(key)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            this.cancelMenuIfNecessary(e);
        }

        public void mousePressed(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            BasicJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.isClickOnButton(e, menu)) {
                if (((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    menu.getModel().setArmed(true);
                    menu.getModel().setPressed(true);
                }
                if (!menu.hasFocus() && menu.isRequestFocusEnabled()) {
                    menu.requestFocus();
                }
            } else {
                BasicJideSplitButtonUI.downButtonPressed(menu);
            }
        }

        private boolean isClickOnButton(MouseEvent e, JMenu menu) {
            if (((JideSplitButton)menu).isAlwaysDropdown()) {
                return false;
            }
            boolean clickOnDropDown = false;
            if (BasicJideButtonUI.shouldWrapText(BasicJideSplitButtonUI.this.menuItem)) {
                int size = 27;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (e.getPoint().getY() < (double)(menu.getHeight() - size)) {
                        clickOnDropDown = true;
                    }
                } else if (e.getPoint().getY() < (double)(menu.getHeight() - size)) {
                    clickOnDropDown = true;
                }
            } else {
                int size;
                int n = size = ((JMenu)BasicJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? BasicJideSplitButtonUI.this._splitButtonMargin : BasicJideSplitButtonUI.this._splitButtonMarginOnMenu;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (menu.getComponentOrientation().isLeftToRight()) {
                        if (e.getPoint().getX() < (double)(menu.getWidth() - size)) {
                            clickOnDropDown = true;
                        }
                    } else if (e.getPoint().getX() >= (double)size) {
                        clickOnDropDown = true;
                    }
                } else if (e.getPoint().getY() < (double)(menu.getHeight() - size)) {
                    clickOnDropDown = true;
                }
            }
            return clickOnDropDown;
        }

        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(e, menu)) {
                BasicJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                BasicJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(e);
        }

        private void cancelMenuIfNecessary(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(e, menu) && ((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    menu.getModel().setPressed(false);
                    menu.getModel().setArmed(false);
                } else {
                    menu.getModel().setArmed(false);
                    menu.getModel().setPressed(false);
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElements = manager.getSelectedPath();
                for (int i = menuElements.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElements[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(menu)) continue;
                    menu.getModel().setRollover(false);
                    BasicJideSplitButtonUI.this.setMouseOver(false);
                    manager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        BasicJideSplitButtonUI.appendPath(BasicJideSplitButtonUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(BasicJideSplitButtonUI.this.getPath());
                        BasicJideSplitButtonUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                BasicJideSplitButtonUI.this.setMouseOver(true);
            }
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent e) {
            BasicJideSplitButtonUI.this.setMouseOver(false);
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (BasicJideSplitButtonUI.this.menuItem instanceof JideSplitButton) {
                if (this.isClickOnButton(e, (JMenu)BasicJideSplitButtonUI.this.menuItem)) {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(true);
                } else {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(false);
                }
            }
        }
    }
}

