/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.services.servicebus.implementation.AuthorizationFilter;
import com.microsoft.windowsazure.services.servicebus.implementation.ServiceBusConnectionSettings;
import com.sun.jersey.api.client.ClientHandlerException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class SasFilter
extends AuthorizationFilter {
    private String key;
    private String value;
    private static final String HMAC_SHA256_ALG = "HmacSHA256";
    private final long fiveMinutes = 300000L;

    public SasFilter(ServiceBusConnectionSettings connectionSettings) {
        this.key = connectionSettings.getSharedAccessKeyName();
        this.value = connectionSettings.getSharedAccessKey();
    }

    @Override
    protected String createAuthorization(String targetUri) {
        try {
            targetUri = URLEncoder.encode(targetUri.toLowerCase(), "UTF-8").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        int expiration = Math.round(new Date(System.currentTimeMillis() + 300000L).getTime() / 1000L);
        String signature = this.valueToSign(targetUri, expiration);
        try {
            String hmac = URLEncoder.encode(this.calculateHmac(signature), "UTF-8");
            return String.format("SharedAccessSignature sig=%s&se=%d&skn=%s&sr=%s", hmac, expiration, this.key, targetUri);
        }
        catch (SignatureException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientHandlerException((Throwable)e);
        }
    }

    private String valueToSign(String targetUri, int expiration) {
        StringBuilder sb = new StringBuilder();
        if (targetUri != null) {
            sb.append(targetUri);
        }
        sb.append("\n").append(expiration);
        return sb.toString();
    }

    private String calculateHmac(String data) throws SignatureException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(this.value.getBytes(), HMAC_SHA256_ALG);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALG);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            return DatatypeConverter.printBase64Binary((byte[])rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }
}

