/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.core.utils.DateFactory;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.servicebus.implementation.ServiceBusConnectionSettings;
import com.microsoft.windowsazure.services.servicebus.implementation.WrapAccessTokenResult;
import com.microsoft.windowsazure.services.servicebus.implementation.WrapContract;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class WrapTokenManager {
    private WrapContract contract;
    private final DateFactory dateFactory;
    private final String uri;
    private final String name;
    private final String password;
    private final Map<String, ActiveToken> activeTokens;

    @Inject
    public WrapTokenManager(WrapContract contract, DateFactory dateFactory, ServiceBusConnectionSettings connectionSettings) {
        this.contract = contract;
        this.dateFactory = dateFactory;
        this.uri = connectionSettings.getWrapUri();
        this.name = connectionSettings.getWrapName();
        this.password = connectionSettings.getWrapPassword();
        this.activeTokens = new ConcurrentHashMap<String, ActiveToken>();
    }

    public WrapContract getContract() {
        return this.contract;
    }

    public void setContract(WrapContract contract) {
        this.contract = contract;
    }

    public String getAccessToken(URI targetUri) throws ServiceException, URISyntaxException {
        Date now = this.dateFactory.getDate();
        URI scopeUri = new URI("http", targetUri.getAuthority(), targetUri.getPath(), null, null);
        String scope = scopeUri.toString();
        ActiveToken active = this.activeTokens.get(scope);
        if (active != null && now.before(active.getExpiresUtc())) {
            return active.getWrapResponse().getAccessToken();
        }
        Iterator<Map.Entry<String, ActiveToken>> iterator = this.activeTokens.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ActiveToken> entry = iterator.next();
            if (now.before(entry.getValue().getExpiresUtc())) continue;
            iterator.remove();
        }
        WrapAccessTokenResult wrapResponse = this.getContract().wrapAccessToken(this.uri, this.name, this.password, scope);
        Date expiresUtc = new Date(now.getTime() + wrapResponse.getExpiresIn() * 1000L / 2L);
        ActiveToken acquired = new ActiveToken();
        acquired.setWrapResponse(wrapResponse);
        acquired.setExpiresUtc(expiresUtc);
        this.activeTokens.put(scope, acquired);
        return wrapResponse.getAccessToken();
    }

    class ActiveToken {
        private Date expiresUtc;
        private WrapAccessTokenResult wrapResponse;

        ActiveToken() {
        }

        public Date getExpiresUtc() {
            return this.expiresUtc;
        }

        public void setExpiresUtc(Date expiresUtc) {
            this.expiresUtc = expiresUtc;
        }

        public WrapAccessTokenResult getWrapResponse() {
            return this.wrapResponse;
        }

        public void setWrapResponse(WrapAccessTokenResult wrapResponse) {
            this.wrapResponse = wrapResponse;
        }
    }
}

