/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import java.io.IOException;
import java.io.InputStream;

public class NetworkInputStream
extends InputStream {
    private final long expectedLength;
    private final InputStream inputStream;
    private long bytesRead = 0L;

    public NetworkInputStream(InputStream stream, long expectedLength) {
        this.inputStream = stream;
        this.expectedLength = expectedLength;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = this.inputStream.read(b, off, len);
        if (count > -1) {
            this.bytesRead += (long)count;
        } else if (this.bytesRead != this.expectedLength) {
            throw new IOException("An incorrect number of bytes was read from the connection. The connection may have been closed.");
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

