/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.netflix.eventbus.impl.EventBusStats;
import com.netflix.servo.monitor.Monitors;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventBusStats {
    protected static final Logger LOGGER = LoggerFactory.getLogger(EventBusStats.class);
    protected long collectionDurationInMillis;
    protected static Timer statsSweeper = new Timer(true);

    public AbstractEventBusStats(long collectionDurationInMillis) {
        this.collectionDurationInMillis = collectionDurationInMillis;
        statsSweeper.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractEventBusStats.this.computeTimeIntervalStats();
            }
        }, collectionDurationInMillis, collectionDurationInMillis);
    }

    protected void registerMonitors() {
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable th) {
            LOGGER.error("Unable to register to event bus stats to servo.", th);
        }
    }

    protected abstract void computeTimeIntervalStats();

    protected class LatencyStats {
        private int sampleSize;
        private double mean;
        private double median;
        private double percentile_99_5;
        private double percentile_99;
        private double percentile_90;
        private double stddev;
        private double max;
        private ConcurrentLinkedQueue<Double> rawData;
        private AtomicReference<LatencyStats> computedData;

        protected LatencyStats() {
            this.rawData = new ConcurrentLinkedQueue();
            this.computedData = new AtomicReference<LatencyStats>(new LatencyStats(this));
        }

        private LatencyStats(LatencyStats copyFrom) {
            this.sampleSize = copyFrom.sampleSize;
            this.mean = copyFrom.mean;
            this.median = copyFrom.median;
            this.percentile_90 = copyFrom.percentile_90;
            this.percentile_99 = copyFrom.percentile_99;
            this.percentile_99_5 = copyFrom.percentile_99_5;
            this.stddev = copyFrom.stddev;
            this.max = copyFrom.max;
        }

        protected void addLatency(double latency) {
            this.rawData.add(latency);
        }

        protected void compute() {
            Percentile percentile = new Percentile();
            double[] rawDataAsArray = this.clearRawDataAndGetAsArray();
            if (null != rawDataAsArray && rawDataAsArray.length != 0) {
                this.sampleSize = rawDataAsArray.length;
                percentile.setData(rawDataAsArray);
                this.percentile_99_5 = percentile.evaluate(99.5);
                this.percentile_99 = percentile.evaluate(99.0);
                this.percentile_90 = percentile.evaluate(90.0);
                this.median = Math.max(1.0, percentile.evaluate(50.0));
                this.max = StatUtils.max((double[])rawDataAsArray);
                this.mean = new Mean().evaluate(rawDataAsArray);
                this.stddev = new StandardDeviation().evaluate(rawDataAsArray);
            }
            this.computedData.set(this.getCopyOfComputedData());
        }

        protected LatencyStats getComputedStats() {
            return this.computedData.get();
        }

        public int getSampleSize() {
            return this.getComputedStats().sampleSize;
        }

        public double getMean() {
            return this.getComputedStats().mean;
        }

        public double getMedian() {
            return this.getComputedStats().median;
        }

        public double getPercentile_99_5() {
            return this.getComputedStats().percentile_99_5;
        }

        public double getPercentile_99() {
            return this.getComputedStats().percentile_99;
        }

        public double getPercentile_90() {
            return this.getComputedStats().percentile_90;
        }

        public double getStddev() {
            return this.getComputedStats().stddev;
        }

        public double getMax() {
            return this.getComputedStats().max;
        }

        private LatencyStats getCopyOfComputedData() {
            return new LatencyStats(this);
        }

        private double[] clearRawDataAndGetAsArray() {
            double[] toReturn = new double[this.rawData.size()];
            int index = 0;
            Iterator<Double> iterator = this.rawData.iterator();
            while (iterator.hasNext()) {
                Double aDataPoint = iterator.next();
                iterator.remove();
                toReturn[index++] = aDataPoint;
            }
            return toReturn;
        }
    }
}

