/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.AbstractAnnotationBeanPostProcessor;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Field;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class GaugeFieldAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements Ordered {
    private static final AnnotationFilter FILTER = new AnnotationFilter(com.codahale.metrics.annotation.Gauge.class, 215);
    private final MetricRegistry metrics;

    public GaugeFieldAnnotationBeanPostProcessor(MetricRegistry metrics) {
        super(AbstractAnnotationBeanPostProcessor.Members.ALL, AbstractAnnotationBeanPostProcessor.Phase.PRE_INIT, FILTER);
        this.metrics = metrics;
    }

    @Override
    protected void withField(final Object bean, String beanName, Class<?> targetClass, final Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        com.codahale.metrics.annotation.Gauge annotation = field.getAnnotation(com.codahale.metrics.annotation.Gauge.class);
        String metricName = Util.forGauge(targetClass, field, annotation);
        this.metrics.register(metricName, (Metric)new Gauge<Object>(){

            public Object getValue() {
                Object value = ReflectionUtils.getField((Field)field, (Object)bean);
                if (value instanceof Gauge) {
                    value = ((Gauge)value).getValue();
                }
                return value;
            }
        });
        this.LOG.debug("Created gauge {} for field {}.{}", new Object[]{metricName, targetClass.getCanonicalName(), field.getName()});
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

