/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.plugin.dockerfile;

import com.spotify.docker.client.ImageRef;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import java.util.HashMap;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRegistryAuthSupplier
implements RegistryAuthSupplier {
    private static final Logger log = LoggerFactory.getLogger(MavenRegistryAuthSupplier.class);
    private final Settings settings;
    private final SettingsDecrypter settingsDecrypter;

    public MavenRegistryAuthSupplier(Settings settings, SettingsDecrypter settingsDecrypter) {
        this.settings = settings;
        this.settingsDecrypter = settingsDecrypter;
    }

    public RegistryAuth authFor(String imageName) throws DockerException {
        ImageRef ref = new ImageRef(imageName);
        Server server = this.settings.getServer(ref.getRegistryName());
        if (server != null) {
            return this.createRegistryAuth(server);
        }
        log.warn("Did not find maven server configuration for docker server " + ref.getRegistryName());
        return null;
    }

    public RegistryAuth authForSwarm() throws DockerException {
        return null;
    }

    public RegistryConfigs authForBuild() throws DockerException {
        HashMap<String, RegistryAuth> allConfigs = new HashMap<String, RegistryAuth>();
        for (Server server : this.settings.getServers()) {
            allConfigs.put(server.getId(), this.createRegistryAuth(server));
        }
        return RegistryConfigs.create(allConfigs);
    }

    private RegistryAuth createRegistryAuth(Server server) throws DockerException {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult decryptionResult = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        if (!decryptionResult.getProblems().isEmpty()) {
            for (SettingsProblem problem : decryptionResult.getProblems()) {
                log.error("Settings problem for server {}: {}", (Object)server.getId(), (Object)problem);
            }
            throw new DockerException("Failed to decrypt Maven server password");
        }
        log.debug("Successfully decrypted Maven server password");
        return RegistryAuth.builder().username(server.getUsername()).password(decryptionResult.getServer().getPassword()).build();
    }
}

