/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.RIConstants;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verifier {
    private static final ThreadLocal<Verifier> VERIFIER = new ThreadLocal();
    private List<String> messages = new ArrayList<String>(4);

    Verifier() {
    }

    public static Verifier getCurrentInstance() {
        return VERIFIER.get();
    }

    public static void setCurrentInstance(Verifier verifier) {
        if (verifier == null) {
            VERIFIER.remove();
        } else {
            VERIFIER.set(verifier);
        }
    }

    public boolean isApplicationValid() {
        return this.messages.isEmpty();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void validateObject(ObjectType type, String className, Class<?> assignableTo) {
        if ("javax.faces.component.html.HtmlHead".equals(className) || "javax.faces.component.html.HtmlBody".equals(className)) {
            return;
        }
        Class c = null;
        try {
            c = Util.loadClass(className, this);
        }
        catch (ClassNotFoundException cnfe) {
            this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.CLASS_NOT_FOUND", new Object[]{type, className}));
        }
        catch (NoClassDefFoundError ncdfe) {
            this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.CLASS_MISSING_DEP", new Object[]{type, className, ncdfe.getMessage()}));
        }
        if (c != null) {
            try {
                Constructor ctor = c.getConstructor(RIConstants.EMPTY_CLASS_ARGS);
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.NON_PUBLIC_DEF_CTOR", new Object[]{type, className}));
                }
            }
            catch (NoSuchMethodException nsme) {
                this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.NO_DEF_CTOR", new Object[]{type, className}));
            }
            if (!assignableTo.isAssignableFrom(c)) {
                this.messages.add(MessageUtils.getExceptionMessageString("com.sun.faces.verifier.WRONG_TYPE", new Object[]{type, className}));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectType {
        COMPONENT,
        CONVERTER,
        VALIDATOR,
        BEHAVIOR;

    }
}

