/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;

public class ModificationTracker {
    private Map<String, String> properties;
    private Map<String, String> classes;
    private final Set<String> propertyNames = new HashSet<String>();
    private final Set<String> classNames = new HashSet<String>();
    private boolean modified = false;
    private boolean failed = false;
    private final File saved;
    private final MessageDigest digest;
    private final Log log;

    ModificationTracker(String buildDirectory, String filename, Log log) throws NoSuchAlgorithmException {
        File output = new File(filename + ".md5s");
        if (output.isAbsolute()) {
            this.saved = output;
        } else {
            this.saved = new File(buildDirectory, output.getPath());
            log.debug((CharSequence)("Adjusted relative path, resulting path is " + this.saved.getPath()));
        }
        this.digest = MessageDigest.getInstance("MD5");
        this.log = log;
    }

    private String calculate(InputStream is) throws IOException {
        int i;
        byte[] buffer = new byte[4096];
        while ((i = is.read(buffer)) > -1) {
            this.digest.update(buffer, 0, i);
        }
        is.close();
        byte[] bytes = this.digest.digest();
        BigInteger bi = new BigInteger(1, bytes);
        return String.format("%0" + (bytes.length << 1) + "x", bi);
    }

    private boolean check(Map<String, String> values, String name, String value) {
        if (!values.containsKey(name) || !values.get(name).equals(value)) {
            values.put(name, value);
            return true;
        }
        return false;
    }

    boolean track(String name, InputStream is) throws IOException {
        boolean result = this.check(this.classes, name, this.calculate(is));
        this.classNames.add(name);
        this.modified |= result;
        return result;
    }

    boolean check(String name, String property) {
        this.propertyNames.add(name);
        return this.check(this.properties, name, property);
    }

    boolean track(String name, String property) {
        boolean result = this.check(name, property);
        this.modified |= result;
        return result;
    }

    boolean track(Properties properties) {
        boolean result = false;
        for (String name : properties.stringPropertyNames()) {
            result |= this.track(name, properties.getProperty(name));
        }
        return result;
    }

    void touch() {
        this.modified = true;
    }

    boolean modified() {
        for (String property : new HashSet<String>(this.properties.keySet())) {
            if (this.propertyNames.contains(property)) continue;
            this.modified = true;
            this.properties.remove(property);
        }
        for (String clazz : new HashSet<String>(this.classes.keySet())) {
            if (this.classNames.contains(clazz)) continue;
            this.modified = true;
            this.classes.remove(clazz);
        }
        return this.modified;
    }

    void failed() {
        this.failed = true;
    }

    void load() {
        if (this.saved.isFile() && this.saved.length() > 0L) {
            try {
                FileInputStream fis = new FileInputStream(this.saved);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.properties = (HashMap)ois.readObject();
                this.classes = (HashMap)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                this.properties = new HashMap<String, String>();
                this.classes = new HashMap<String, String>();
                this.log.warn((CharSequence)("Cannot read md5s from saved: " + e));
            }
        } else {
            this.properties = new HashMap<String, String>();
            this.classes = new HashMap<String, String>();
            try {
                this.saved.createNewFile();
            }
            catch (IOException e) {
                this.log.debug((CharSequence)("Cannot create file \"" + this.saved.getPath() + "\" for md5s: " + e));
            }
        }
    }

    void save() {
        if (this.failed) {
            this.saved.delete();
            return;
        }
        if (!this.modified) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.saved);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.properties);
            oos.writeObject(this.classes);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            this.log.error((CharSequence)("Cannot write md5-sums to file: " + e));
        }
    }
}

