/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class JsonJava {
    private JsonJava() {
    }

    public static Object asJava(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                switch (jsonNode.size()) {
                    case 0: {
                        return Collections.emptyList();
                    }
                    case 1: {
                        return Collections.singletonList(JsonJava.asJava(jsonNode.get(0)));
                    }
                }
                return StreamSupport.stream(jsonNode.spliterator(), false).map(JsonJava::asJava).collect(Collectors.toList());
            }
            case OBJECT: {
                switch (jsonNode.size()) {
                    case 0: {
                        return Collections.emptyMap();
                    }
                    case 1: {
                        Map.Entry entry = (Map.Entry)jsonNode.fields().next();
                        return Collections.singletonMap(entry.getKey(), JsonJava.asJava((JsonNode)entry.getValue()));
                    }
                }
                TreeMap treeMap = new TreeMap();
                Iterator iterator = jsonNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    treeMap.put(entry.getKey(), JsonJava.asJava((JsonNode)entry.getValue()));
                }
                return treeMap;
            }
            case STRING: {
                return jsonNode.textValue();
            }
            case BOOLEAN: {
                return jsonNode.booleanValue();
            }
            case NULL: {
                return null;
            }
            case NUMBER: {
                switch (jsonNode.numberType()) {
                    case INT: {
                        return jsonNode.intValue();
                    }
                    case LONG: {
                        return jsonNode.longValue();
                    }
                    case FLOAT: {
                        return Float.valueOf(jsonNode.floatValue());
                    }
                    case DOUBLE: {
                        return jsonNode.doubleValue();
                    }
                    case BIG_INTEGER: {
                        return jsonNode.bigIntegerValue();
                    }
                    case BIG_DECIMAL: {
                        return jsonNode.decimalValue();
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported node type " + jsonNode.getNodeType());
    }
}

