/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.kms.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.kms.runtime.KmsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsClient;

@Recorder
public class KmsRecorder
extends AmazonClientRecorder {
    final KmsConfig config;

    public KmsRecorder(KmsConfig config) {
        this.config = config;
    }

    public RuntimeValue<AwsConfig> getAwsConfig() {
        return new RuntimeValue((Object)this.config.aws());
    }

    public RuntimeValue<SdkConfig> getSdkConfig() {
        return new RuntimeValue((Object)this.config.sdk());
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return KmsClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return KmsAsyncClient.builder();
    }
}

