/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.cxf")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface CxfFixedConfig {
    @WithDefault(value="/services")
    public String path();

    @WithDefault(value="128")
    public int minChunkSize();

    @WithDefault(value="8191")
    public int outputBufferSize();

    public Optional<CxfClientConfig.HTTPConduitImpl> httpConduitFactory();

    @WithName(value="client")
    public Map<String, ClientFixedConfig> clients();

    @ConfigGroup
    public static interface NativeClientFixedConfig {
        @WithDefault(value="false")
        public boolean runtimeInitialized();
    }

    @ConfigGroup
    public static interface ClientFixedConfig {
        public Optional<String> serviceInterface();

        @WithDefault(value="false")
        public boolean alternative();

        @WithName(value="native")
        public NativeClientFixedConfig native_();

        public static ClientFixedConfig createDefault() {
            return new ClientFixedConfig(){

                @Override
                public Optional<String> serviceInterface() {
                    return Optional.empty();
                }

                @Override
                public boolean alternative() {
                    return false;
                }

                @Override
                public NativeClientFixedConfig native_() {
                    return null;
                }
            };
        }
    }
}

