/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport.generated;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkiverse.cxf.transport.VertxReactiveRequestContext;
import io.quarkiverse.cxf.transport.generated.AppendBuffer;
import io.quarkus.vertx.core.runtime.VertxBufferImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.jboss.logging.Logger;

public class VertxServletOutputStream
extends ServletOutputStream {
    private static final Logger log = Logger.getLogger((String)"org.jboss.resteasy.reactive.server.vertx.ResteasyReactiveOutputStream");
    private final VertxReactiveRequestContext context;
    protected final HttpServerRequest request;
    private final AppendBuffer appendBuffer;
    private boolean committed;
    private boolean closed;
    protected boolean waitingForDrain;
    protected boolean drainHandlerRegistered;
    protected boolean first = true;
    protected Throwable throwable;
    private ByteArrayOutputStream overflow;

    public VertxServletOutputStream(VertxReactiveRequestContext context) {
        this.context = context;
        this.request = context.getContext().request();
        this.appendBuffer = AppendBuffer.withMinChunks((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, context.getDeployment().getResteasyReactiveConfig().getMinChunkSize(), context.getDeployment().getResteasyReactiveConfig().getOutputBufferSize());
        this.request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Throwable event) {
                VertxServletOutputStream.this.throwable = event;
                log.debugf(event, "IO Exception ", new Object[0]);
                VertxServletOutputStream.this.terminateResponse();
                VertxServletOutputStream.this.request.connection().close();
                HttpConnection httpConnection = VertxServletOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxServletOutputStream.this.waitingForDrain) {
                        VertxServletOutputStream.this.request.connection().notifyAll();
                    }
                }
            }
        });
        DrainHandler handler = new DrainHandler(this);
        this.request.response().drainHandler((Handler)handler);
        this.request.response().closeHandler((Handler)handler);
        context.getContext().addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(AsyncResult<Void> event) {
                HttpConnection httpConnection = VertxServletOutputStream.this.request.connection();
                synchronized (httpConnection) {
                    if (VertxServletOutputStream.this.waitingForDrain) {
                        VertxServletOutputStream.this.request.connection().notifyAll();
                    }
                }
                VertxServletOutputStream.this.terminateResponse();
            }
        });
    }

    public void terminateResponse() {
    }

    Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end((Handler)null);
            return;
        }
        HttpConnection httpConnection = this.request.connection();
        synchronized (httpConnection) {
            try {
                boolean bufferRequired;
                boolean bl = bufferRequired = this.awaitWriteable() || this.overflow != null && this.overflow.size() > 0;
                if (bufferRequired) {
                    if (this.overflow == null) {
                        this.overflow = new ByteArrayOutputStream();
                    }
                    if (data.hasArray()) {
                        this.overflow.write(data.array(), data.arrayOffset() + data.readerIndex(), data.readableBytes());
                    } else {
                        data.getBytes(data.readerIndex(), (OutputStream)this.overflow, data.readableBytes());
                    }
                    if (last) {
                        this.closed = true;
                    }
                    data.release();
                } else if (last) {
                    this.request.response().end(this.createBuffer(data), null);
                } else {
                    this.request.response().write((Object)this.createBuffer(data), null);
                }
            }
            catch (Exception e) {
                if (data != null && data.refCnt() > 0) {
                    data.release();
                }
                throw new IOException("Failed to write", e);
            }
        }
    }

    private boolean awaitWriteable() throws IOException {
        if (Vertx.currentContext() == ((HttpServerRequestInternal)this.request).context()) {
            return false;
        }
        if (this.first) {
            this.first = false;
            return false;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
        return false;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        int rem = len;
        int idx = off;
        try {
            while (rem > 0) {
                int written = this.appendBuffer.append(b, idx, rem);
                if (written < rem) {
                    this.writeBlocking(this.appendBuffer.clear(), false);
                }
                rem -= written;
                idx += written;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.prepareWrite(buffer, finished);
        this.write(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.committed) {
            this.committed = true;
            if (finished) {
                HttpServerResponse response = this.request.response();
                if (!response.headWritten()) {
                    if (buffer == null) {
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)"0");
                    } else {
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.readableBytes()));
                    }
                }
            } else {
                this.request.response().setChunked(true);
            }
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        try {
            ByteBuf toFlush = this.appendBuffer.clear();
            if (toFlush != null) {
                this.writeBlocking(toFlush, false);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.writeBlocking(this.appendBuffer.clear(), true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    public boolean isReady() {
        throw new UnsupportedOperationException();
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }

    private static class DrainHandler
    implements Handler<Void> {
        private final VertxServletOutputStream out;

        public DrainHandler(VertxServletOutputStream out) {
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Void event) {
            HttpConnection httpConnection = this.out.request.connection();
            synchronized (httpConnection) {
                if (this.out.waitingForDrain) {
                    this.out.request.connection().notifyAll();
                }
                if (this.out.overflow != null && this.out.overflow.size() > 0) {
                    if (this.out.closed) {
                        this.out.request.response().end(Buffer.buffer((byte[])this.out.overflow.toByteArray()), null);
                    } else {
                        this.out.request.response().write((Object)Buffer.buffer((byte[])this.out.overflow.toByteArray()), null);
                    }
                    this.out.overflow.reset();
                }
            }
        }
    }
}

