/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MediaType;

public final class ValidatorMediaTypeUtil {
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_PLAIN_TYPE);

    private ValidatorMediaTypeUtil() {
    }

    public static MediaType getAcceptMediaTypeFromSupported(List<MediaType> mediaTypesFromRequest) {
        return ValidatorMediaTypeUtil.getAcceptMediaType(mediaTypesFromRequest, SUPPORTED_MEDIA_TYPES);
    }

    public static MediaType getAcceptMediaType(List<MediaType> mediaTypesFromRequest, List<MediaType> mediaTypesFromProducesAnnotation) {
        for (MediaType mediaType : mediaTypesFromRequest) {
            if (!ValidatorMediaTypeUtil.isMediaTypeInList(mediaType, SUPPORTED_MEDIA_TYPES) || !ValidatorMediaTypeUtil.isMediaTypeInList(mediaType, mediaTypesFromProducesAnnotation)) continue;
            return mediaType;
        }
        if (mediaTypesFromProducesAnnotation.isEmpty()) {
            return null;
        }
        return mediaTypesFromProducesAnnotation.get(0);
    }

    private static boolean isMediaTypeInList(MediaType mediaType, List<MediaType> list) {
        for (MediaType item : list) {
            if (!mediaType.getType().equalsIgnoreCase(item.getType()) || !mediaType.getSubtype().equalsIgnoreCase(item.getSubtype())) continue;
            return true;
        }
        return false;
    }
}

