/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.TemplateData;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.Descriptors;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ValueResolverGenerator {
    public static final DotName TEMPLATE_DATA = DotName.createSimple((String)TemplateData.class.getName());
    public static final DotName TEMPLATE_DATA_CONTAINER = DotName.createSimple((String)TemplateData.Container.class.getName());
    private static final DotName COMPLETION_STAGE = DotName.createSimple((String)CompletionStage.class.getName());
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final DotName BOOLEAN = DotName.createSimple((String)Boolean.class.getName());
    public static final String SUFFIX = "_ValueResolver";
    public static final String NESTED_SEPARATOR = "$_";
    private static final Logger LOGGER = Logger.getLogger(ValueResolverGenerator.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String HAS_PREFIX = "has";
    public static final String TARGET = "target";
    public static final String IGNORE_SUPERCLASSES = "ignoreSuperclasses";
    public static final String IGNORE = "ignore";
    public static final String PROPERTIES = "properties";
    public static final int DEFAULT_PRIORITY = 10;
    private final Set<String> generatedTypes = new HashSet<String>();
    private final IndexView index;
    private final ClassOutput classOutput;
    private final Map<DotName, ClassInfo> nameToClass;
    private final Map<DotName, AnnotationInstance> nameToTemplateData;

    public static Builder builder() {
        return new Builder();
    }

    ValueResolverGenerator(IndexView index, ClassOutput classOutput, Map<DotName, ClassInfo> nameToClass, Map<DotName, AnnotationInstance> nameToTemplateData) {
        this.classOutput = classOutput;
        this.index = index;
        this.nameToClass = new HashMap<DotName, ClassInfo>(nameToClass);
        this.nameToTemplateData = new HashMap<DotName, AnnotationInstance>(nameToTemplateData);
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public void generate() {
        HashMap<DotName, Set> superToSub = new HashMap<DotName, Set>();
        for (Map.Entry<DotName, ClassInfo> entry : this.nameToClass.entrySet()) {
            DotName superName = entry.getValue().superName();
            if (superName == null || OBJECT.equals((Object)superName)) continue;
            superToSub.computeIfAbsent(superName, name -> new HashSet()).add(entry.getKey());
        }
        int priority = 10;
        HashMap<DotName, ClassInfo> remaining = new HashMap<DotName, ClassInfo>(this.nameToClass);
        while (!remaining.isEmpty()) {
            HashMap<DotName, Set> superToSubRemovals = new HashMap<DotName, Set>();
            Iterator it = remaining.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (superToSub.containsKey(entry.getKey())) continue;
                this.generate((DotName)entry.getKey(), priority);
                DotName superName = ((ClassInfo)entry.getValue()).superName();
                if (superName != null && !OBJECT.equals((Object)superName)) {
                    superToSubRemovals.computeIfAbsent(superName, name -> new HashSet()).add(entry.getKey());
                }
                it.remove();
            }
            for (Map.Entry entry : superToSubRemovals.entrySet()) {
                Set subs = (Set)superToSub.get(entry.getKey());
                if (subs == null) continue;
                subs.removeAll((Collection)entry.getValue());
                if (!subs.isEmpty()) continue;
                superToSub.remove(entry.getKey());
            }
            --priority;
        }
    }

    private void generate(DotName className, int priority) {
        AnnotationValue ignoreSuperclassesValue;
        ClassInfo clazz = this.nameToClass.get(className);
        String clazzName = className.toString();
        boolean ignoreSuperclasses = false;
        AnnotationInstance templateData = this.nameToTemplateData.get(className);
        if (templateData == null) {
            for (AnnotationInstance annotation : clazz.classAnnotations()) {
                AnnotationValue targetValue;
                if (!annotation.name().equals((Object)TEMPLATE_DATA) || (targetValue = annotation.value(TARGET)) != null && !targetValue.asClass().name().equals((Object)className)) continue;
                templateData = annotation;
            }
        }
        if (templateData != null && (ignoreSuperclassesValue = templateData.value(IGNORE_SUPERCLASSES)) != null) {
            ignoreSuperclasses = ignoreSuperclassesValue.asBoolean();
        }
        Predicate<AnnotationTarget> filters = this.initFilters(templateData);
        LOGGER.debugf("Analyzing %s", (Object)clazzName);
        String baseName = clazz.enclosingClass() != null ? ValueResolverGenerator.simpleName(clazz.enclosingClass()) + NESTED_SEPARATOR + ValueResolverGenerator.simpleName(clazz) : ValueResolverGenerator.simpleName(clazz);
        String targetPackage = ValueResolverGenerator.packageName(clazz.name());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, baseName, SUFFIX);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator valueResolver = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{ValueResolver.class}).build();
        this.implementGetPriority(valueResolver, priority);
        this.implementAppliesTo(valueResolver, clazz);
        this.implementResolve(valueResolver, clazzName, clazz, filters, ignoreSuperclasses);
        valueResolver.close();
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        MethodCreator getPriority = (MethodCreator)valueResolver.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(priority));
    }

    /*
     * WARNING - void declaration
     */
    private void implementResolve(ClassCreator valueResolver, String clazzName, ClassInfo clazz, Predicate<AnnotationTarget> filter, boolean ignoreSuperclasses) {
        MethodCreator resolve = (MethodCreator)valueResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle base = resolve.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        ResultHandle params = resolve.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
        ResultHandle paramsCount = resolve.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, params, new ResultHandle[0]);
        List fields = clazz.fields().stream().filter(filter::test).collect(Collectors.toList());
        if (!fields.isEmpty()) {
            BytecodeCreator zeroParamsBranch = resolve.ifNonZero(paramsCount).falseBranch();
            for (FieldInfo field : fields) {
                void var17_17;
                LOGGER.debugf("Field added: %s", (Object)field);
                BytecodeCreator fieldMatch = zeroParamsBranch.ifNonZero(zeroParamsBranch.invokeVirtualMethod(Descriptors.EQUALS, resolve.load(field.name()), new ResultHandle[]{name})).trueBranch();
                if (Modifier.isStatic(field.flags())) {
                    ResultHandle resultHandle = fieldMatch.readStaticField(FieldDescriptor.of((String)clazzName, (String)field.name(), (String)field.type().name().toString()));
                } else {
                    ResultHandle resultHandle = fieldMatch.readInstanceField(FieldDescriptor.of((String)clazzName, (String)field.name(), (String)field.type().name().toString()), base);
                }
                fieldMatch.returnValue(fieldMatch.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{var17_17}));
            }
        }
        List methods = clazz.methods().stream().filter(filter::test).map(MethodKey::new).sorted().collect(Collectors.toList());
        if (!ignoreSuperclasses) {
            DotName superName = clazz.superName();
            while (superName != null && !superName.equals((Object)OBJECT)) {
                ClassInfo superClass = this.index.getClassByName(superName);
                if (superClass != null) {
                    methods.addAll(superClass.methods().stream().filter(filter::test).map(MethodKey::new).collect(Collectors.toSet()));
                    superName = superClass.superName();
                    continue;
                }
                superName = null;
                LOGGER.warnf("Skipping super class %s - not found in the index", (Object)clazz.superClassType());
            }
        }
        if (!methods.isEmpty()) {
            HashMap<Match, ArrayList<MethodInfo>> matches = new HashMap<Match, ArrayList<MethodInfo>>();
            HashMap varargsMatches = new HashMap();
            for (MethodKey methodKey : methods) {
                MethodInfo method = methodKey.method;
                List methodParams = method.parameters();
                if (methodParams.isEmpty()) {
                    LOGGER.debugf("Method added %s", (Object)method);
                    BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, method.name(), 0, method.returnType(), name, params, paramsCount);
                    Throwable throwable = null;
                    try {
                        boolean hasCompletionStage = !this.skipMemberType(method.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(method.returnType().name()), this.index);
                        ResultHandle invokeRet = Modifier.isInterface(clazz.flags()) ? matchScope.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)method), base, new ResultHandle[0]) : matchScope.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)method), base, new ResultHandle[0]);
                        ResultHandle ret = hasCompletionStage ? invokeRet : matchScope.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{invokeRet});
                        matchScope.returnValue(ret);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (matchScope == null) continue;
                        if (throwable != null) {
                            try {
                                matchScope.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        matchScope.close();
                        continue;
                    }
                }
                Match match = new Match(method.name(), method.parameters().size());
                List<MethodInfo> methodMatches = (ArrayList<MethodInfo>)matches.get(match);
                if (methodMatches == null) {
                    methodMatches = new ArrayList<MethodInfo>();
                    matches.put(match, (ArrayList<MethodInfo>)methodMatches);
                }
                methodMatches.add(method);
                if (!ValueResolverGenerator.isVarArgs(method)) continue;
                match = new Match(method.name(), method.parameters().size() - 1);
                methodMatches = (List)varargsMatches.get(match);
                if (methodMatches == null) {
                    methodMatches = new ArrayList();
                    varargsMatches.put(match, methodMatches);
                }
                methodMatches.add(method);
            }
            for (Map.Entry entry : matches.entrySet()) {
                Match match = (Match)entry.getKey();
                HashSet<MethodInfo> methodMatches = new HashSet<MethodInfo>((Collection)entry.getValue());
                varargsMatches.entrySet().stream().filter(e -> ((Match)e.getKey()).name.equals(match.name) && ((Match)e.getKey()).paramsCount >= match.paramsCount).forEach(e -> methodMatches.addAll((Collection)e.getValue()));
                if (methodMatches.size() == 1) {
                    this.matchMethod((MethodInfo)methodMatches.iterator().next(), clazz, resolve, base, name, params, paramsCount, evalContext);
                    continue;
                }
                this.matchMethods(match.name, match.paramsCount, methodMatches, clazz, resolve, base, name, params, paramsCount, evalContext);
            }
            HashMap varargsMap = new HashMap();
            for (Map.Entry entry : varargsMatches.entrySet()) {
                ArrayList list = (ArrayList)varargsMap.get(((Match)entry.getKey()).name);
                if (list == null) {
                    list = new ArrayList();
                    varargsMap.put(((Match)entry.getKey()).name, list);
                }
                list.addAll((Collection)entry.getValue());
            }
            for (Map.Entry entry : varargsMap.entrySet()) {
                this.matchMethods((String)entry.getKey(), Integer.MIN_VALUE, (Collection)entry.getValue(), clazz, resolve, base, name, params, paramsCount, evalContext);
            }
        }
        resolve.returnValue(resolve.readStaticField(Descriptors.RESULTS_NOT_FOUND));
    }

    private void matchMethod(MethodInfo method, ClassInfo clazz, MethodCreator resolve, ResultHandle base, ResultHandle name, ResultHandle params, ResultHandle paramsCount, ResultHandle evalContext) {
        List methodParams = method.parameters();
        LOGGER.debugf("Method added %s", (Object)method);
        BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, method.name(), methodParams.size(), method.returnType(), name, params, paramsCount);
        boolean hasCompletionStage = !this.skipMemberType(method.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(method.returnType().name()), this.index);
        ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle evaluatedParams = matchScope.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{evalContext});
        ResultHandle paramsReady = matchScope.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParams);
        FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
        matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
        BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
        AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
        whenComplete.assign(whenBase, base);
        AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
        whenComplete.assign(whenRet, ret);
        AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
        whenComplete.assign(whenEvaluatedParams, evaluatedParams);
        BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
        BytecodeCreator success = throwableIsNull.trueBranch();
        List parameterTypes = method.parameters();
        ResultHandle paramTypesHandle = success.newArray(Class.class, parameterTypes.size());
        int idx = 0;
        for (Type parameterType : parameterTypes) {
            success.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(success, parameterType));
        }
        BytecodeCreator typeMatchFailed = success.ifNonZero(success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{success.load(ValueResolverGenerator.isVarArgs(method)), paramTypesHandle})).falseBranch();
        typeMatchFailed.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{typeMatchFailed.readStaticField(Descriptors.RESULT_NOT_FOUND)});
        typeMatchFailed.returnValue(null);
        ResultHandle[] paramsHandle = new ResultHandle[methodParams.size()];
        if (methodParams.size() == 1) {
            paramsHandle[0] = whenComplete.getMethodParam(0);
        } else {
            for (int i = 0; i < methodParams.size(); ++i) {
                paramsHandle[i] = success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, evaluatedParams, new ResultHandle[]{success.load(i)});
            }
        }
        AssignableResultHandle invokeRet = success.createVariable(Object.class);
        TryBlock tryCatch = success.tryBlock();
        CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
        exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
        if (Modifier.isInterface(clazz.flags())) {
            tryCatch.assign(invokeRet, tryCatch.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
        } else {
            tryCatch.assign(invokeRet, tryCatch.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
        }
        if (hasCompletionStage) {
            FunctionCreator invokeWhenCompleteFun = tryCatch.createFunction(BiConsumer.class);
            tryCatch.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, (ResultHandle)invokeRet, new ResultHandle[]{invokeWhenCompleteFun.getInstance()});
            BytecodeCreator invokeWhenComplete = invokeWhenCompleteFun.getBytecode();
            AssignableResultHandle invokeWhenRet = invokeWhenComplete.createVariable(CompletableFuture.class);
            invokeWhenComplete.assign(invokeWhenRet, (ResultHandle)whenRet);
            BranchResult invokeThrowableIsNull = invokeWhenComplete.ifNull(invokeWhenComplete.getMethodParam(1));
            BytecodeCreator invokeSuccess = invokeThrowableIsNull.trueBranch();
            invokeSuccess.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(0)});
            BytecodeCreator invokeFailure = invokeThrowableIsNull.falseBranch();
            invokeFailure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(1)});
            invokeWhenComplete.returnValue(null);
        } else {
            tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
        }
        BytecodeCreator failure = throwableIsNull.falseBranch();
        failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
        whenComplete.returnValue(null);
        matchScope.returnValue(ret);
    }

    private void matchMethods(String matchName, int matchParamsCount, Collection<MethodInfo> methods, ClassInfo clazz, MethodCreator resolve, ResultHandle base, ResultHandle name, ResultHandle params, ResultHandle paramsCount, ResultHandle evalContext) {
        ResultHandle[] paramsHandle;
        LOGGER.debugf("Methods added %s", methods);
        BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, matchName, matchParamsCount, null, name, params, paramsCount);
        ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle evaluatedParams = matchScope.invokeStaticMethod(Descriptors.EVALUATED_PARAMS_EVALUATE, new ResultHandle[]{evalContext});
        ResultHandle paramsReady = matchScope.readInstanceField(Descriptors.EVALUATED_PARAMS_STAGE, evaluatedParams);
        FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
        matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, paramsReady, new ResultHandle[]{whenCompleteFun.getInstance()});
        BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
        AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
        whenComplete.assign(whenBase, base);
        AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
        whenComplete.assign(whenRet, ret);
        AssignableResultHandle whenEvaluatedParams = whenComplete.createVariable(EvaluatedParams.class);
        whenComplete.assign(whenEvaluatedParams, evaluatedParams);
        BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
        BytecodeCreator success = throwableIsNull.trueBranch();
        if (matchParamsCount == 1) {
            paramsHandle = new ResultHandle[]{success.getMethodParam(0)};
        } else if (matchParamsCount < 0) {
            paramsHandle = null;
        } else {
            paramsHandle = new ResultHandle[matchParamsCount];
            for (int i = 0; i < matchParamsCount; ++i) {
                paramsHandle[i] = success.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, evaluatedParams, new ResultHandle[]{success.load(i)});
            }
        }
        for (MethodInfo method : methods) {
            boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
            BytecodeCreator paramMatchScope = success.createScope();
            Throwable throwable = null;
            try {
                List parameterTypes = method.parameters();
                ResultHandle paramTypesHandle = paramMatchScope.newArray(Class.class, parameterTypes.size());
                int idx = 0;
                for (Type parameterType : parameterTypes) {
                    paramMatchScope.writeArrayValue(paramTypesHandle, idx++, ValueResolverGenerator.loadParamType(paramMatchScope, parameterType));
                }
                paramMatchScope.ifNonZero(paramMatchScope.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{paramMatchScope.load(isVarArgs), paramTypesHandle})).falseBranch().breakScope(paramMatchScope);
                boolean hasCompletionStage = !this.skipMemberType(method.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(method.returnType().name()), this.index);
                AssignableResultHandle invokeRet = paramMatchScope.createVariable(Object.class);
                TryBlock tryCatch = paramMatchScope.tryBlock();
                CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
                exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
                ResultHandle[] realParamsHandle = paramsHandle;
                if (isVarArgs) {
                    ResultHandle varargsResults;
                    realParamsHandle = new ResultHandle[parameterTypes.size()];
                    for (int i = 0; i < parameterTypes.size() - 1; ++i) {
                        ResultHandle resultHandle;
                        realParamsHandle[i] = resultHandle = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_RESULT, (ResultHandle)whenEvaluatedParams, new ResultHandle[]{tryCatch.load(i)});
                    }
                    Type varargsParam = (Type)parameterTypes.get(parameterTypes.size() - 1);
                    ResultHandle componentType = tryCatch.loadClass(varargsParam.asArrayType().component().name().toString());
                    realParamsHandle[parameterTypes.size() - 1] = varargsResults = tryCatch.invokeVirtualMethod(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, evaluatedParams, new ResultHandle[]{tryCatch.load(parameterTypes.size()), componentType});
                }
                if (Modifier.isInterface(clazz.flags())) {
                    tryCatch.assign(invokeRet, tryCatch.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, realParamsHandle));
                } else {
                    tryCatch.assign(invokeRet, tryCatch.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, realParamsHandle));
                }
                if (hasCompletionStage) {
                    FunctionCreator invokeWhenCompleteFun = tryCatch.createFunction(BiConsumer.class);
                    tryCatch.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, (ResultHandle)invokeRet, new ResultHandle[]{invokeWhenCompleteFun.getInstance()});
                    BytecodeCreator invokeWhenComplete = invokeWhenCompleteFun.getBytecode();
                    AssignableResultHandle invokeWhenRet = invokeWhenComplete.createVariable(CompletableFuture.class);
                    invokeWhenComplete.assign(invokeWhenRet, (ResultHandle)whenRet);
                    BranchResult invokeThrowableIsNull = invokeWhenComplete.ifNull(invokeWhenComplete.getMethodParam(1));
                    BytecodeCreator invokeSuccess = invokeThrowableIsNull.trueBranch();
                    invokeSuccess.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(0)});
                    BytecodeCreator invokeFailure = invokeThrowableIsNull.falseBranch();
                    invokeFailure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(1)});
                    invokeWhenComplete.returnValue(null);
                    continue;
                }
                tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (paramMatchScope == null) continue;
                if (throwable != null) {
                    try {
                        paramMatchScope.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                paramMatchScope.close();
            }
        }
        BytecodeCreator failure = throwableIsNull.falseBranch();
        failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
        whenComplete.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.readStaticField(Descriptors.RESULT_NOT_FOUND)});
        whenComplete.returnValue(null);
        matchScope.returnValue(ret);
    }

    static ResultHandle loadParamType(BytecodeCreator creator, Type paramType) {
        if (Type.Kind.PRIMITIVE.equals((Object)paramType.kind())) {
            switch (paramType.asPrimitiveType().primitive()) {
                case INT: {
                    return creator.loadClass(Integer.class);
                }
                case LONG: {
                    return creator.loadClass(Long.class);
                }
                case BOOLEAN: {
                    return creator.loadClass(Boolean.class);
                }
                case BYTE: {
                    return creator.loadClass(Byte.class);
                }
                case CHAR: {
                    return creator.loadClass(Character.class);
                }
                case DOUBLE: {
                    return creator.loadClass(Double.class);
                }
                case FLOAT: {
                    return creator.loadClass(Float.class);
                }
                case SHORT: {
                    return creator.loadClass(Short.class);
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type: " + paramType);
        }
        return creator.loadClass(paramType.name().toString());
    }

    private BytecodeCreator createMatchScope(BytecodeCreator bytecodeCreator, String methodName, int methodParams, Type returnType, ResultHandle name, ResultHandle params, ResultHandle paramsCount) {
        BytecodeCreator matchScope = bytecodeCreator.createScope();
        BytecodeCreator notMatched = matchScope.ifNonZero(matchScope.invokeVirtualMethod(Descriptors.EQUALS, matchScope.load(methodName), new ResultHandle[]{name})).falseBranch();
        if (methodParams == 0 && ValueResolverGenerator.isGetterName(methodName, returnType)) {
            notMatched.ifNonZero(notMatched.invokeVirtualMethod(Descriptors.EQUALS, notMatched.load(ValueResolverGenerator.getPropertyName(methodName)), new ResultHandle[]{name})).falseBranch().breakScope(matchScope);
        } else {
            notMatched.breakScope(matchScope);
        }
        if (methodParams >= 0) {
            matchScope.ifIntegerEqual(matchScope.load(methodParams), paramsCount).falseBranch().breakScope(matchScope);
        }
        return matchScope;
    }

    private void implementAppliesTo(ClassCreator valueResolver, ClassInfo clazz) {
        MethodCreator appliesTo = (MethodCreator)valueResolver.getMethodCreator("appliesTo", Boolean.TYPE, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = appliesTo.getMethodParam(0);
        ResultHandle base = appliesTo.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        BranchResult baseTest = appliesTo.ifNull(base);
        BytecodeCreator baseNotNullBranch = baseTest.falseBranch();
        ResultHandle baseClass = baseNotNullBranch.invokeVirtualMethod(Descriptors.GET_CLASS, base, new ResultHandle[0]);
        ResultHandle testClass = baseNotNullBranch.loadClass(clazz.name().toString());
        ResultHandle test = baseNotNullBranch.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{baseClass});
        BytecodeCreator baseAssignableBranch = baseNotNullBranch.ifNonZero(test).trueBranch();
        baseAssignableBranch.returnValue(baseAssignableBranch.load(true));
        appliesTo.returnValue(appliesTo.load(false));
    }

    private boolean skipMemberType(Type type) {
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case ARRAY: 
            case TYPE_VARIABLE: 
            case UNRESOLVED_TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                return true;
            }
        }
        return false;
    }

    private Predicate<AnnotationTarget> initFilters(AnnotationInstance templateData) {
        Predicate<AnnotationTarget> filter = ValueResolverGenerator::defaultFilter;
        if (templateData != null) {
            AnnotationValue propertiesValue;
            AnnotationValue ignoreValue = templateData.value(IGNORE);
            if (ignoreValue != null) {
                List ignore = Arrays.asList(ignoreValue.asStringArray()).stream().map(Pattern::compile).collect(Collectors.toList());
                filter = filter.and(t -> {
                    if (t.kind() == AnnotationTarget.Kind.FIELD) {
                        return !ignore.stream().anyMatch(p -> p.matcher(t.asField().name()).matches());
                    }
                    return !ignore.stream().anyMatch(p -> p.matcher(t.asMethod().name()).matches());
                });
            }
            if ((propertiesValue = templateData.value(PROPERTIES)) != null && propertiesValue.asBoolean()) {
                filter = filter.and(ValueResolverGenerator::propertiesFilter);
            }
        } else {
            filter = filter.and(ValueResolverGenerator::propertiesFilter);
        }
        return filter;
    }

    static boolean propertiesFilter(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().parameters().size() == 0;
        }
        return true;
    }

    static boolean defaultFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                MethodInfo method = target.asMethod();
                return Modifier.isPublic(method.flags()) && !Modifier.isStatic(method.flags()) && !ValueResolverGenerator.isSynthetic(method.flags()) && method.returnType().kind() != Type.Kind.VOID && !method.name().equals("<init>") && !method.name().equals("<clinit>");
            }
            case FIELD: {
                FieldInfo field = target.asField();
                return Modifier.isPublic(field.flags()) && !Modifier.isStatic(field.flags()) && !ValueResolverGenerator.isSynthetic(field.flags());
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    static boolean isGetterName(String name, Type returnType) {
        if (name.startsWith(GET_PREFIX)) {
            return true;
        }
        if (returnType == null || returnType.name().equals((Object)PrimitiveType.BOOLEAN.name()) || returnType.name().equals((Object)BOOLEAN)) {
            return name.startsWith(IS_PREFIX) || name.startsWith(HAS_PREFIX);
        }
        return false;
    }

    public static String getPropertyName(String methodName) {
        String propertyName = methodName;
        if (methodName.startsWith(GET_PREFIX)) {
            propertyName = methodName.substring(GET_PREFIX.length(), methodName.length());
        } else if (methodName.startsWith(IS_PREFIX)) {
            propertyName = methodName.substring(IS_PREFIX.length(), methodName.length());
        } else if (methodName.startsWith(HAS_PREFIX)) {
            propertyName = methodName.substring(HAS_PREFIX.length(), methodName.length());
        }
        return ValueResolverGenerator.decapitalize(propertyName);
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static String simpleName(ClassInfo clazz) {
        switch (clazz.nestingType()) {
            case TOP_LEVEL: {
                return ValueResolverGenerator.simpleName(clazz.name());
            }
            case INNER: {
                return clazz.simpleName();
            }
        }
        throw new IllegalStateException("Unsupported nesting type: " + clazz);
    }

    static String simpleName(DotName dotName) {
        return ValueResolverGenerator.simpleName(dotName.toString());
    }

    static String simpleName(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
    }

    static String packageName(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    static String generatedNameFromTarget(String targetPackage, String baseName, String suffix) {
        if (targetPackage == null || targetPackage.isEmpty()) {
            return baseName + suffix;
        }
        if (targetPackage.startsWith("java")) {
            return "io/quarkus/qute/" + baseName + suffix;
        }
        return targetPackage.replace('.', '/') + "/" + baseName + suffix;
    }

    public static boolean hasCompletionStageInTypeClosure(ClassInfo classInfo, IndexView index) {
        return ValueResolverGenerator.hasClassInTypeClosure(classInfo, COMPLETION_STAGE, index);
    }

    public static boolean hasClassInTypeClosure(ClassInfo classInfo, DotName className, IndexView index) {
        ClassInfo superClassInfo;
        if (classInfo == null) {
            return false;
        }
        if (classInfo.name().equals((Object)className)) {
            return true;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null || !ValueResolverGenerator.hasCompletionStageInTypeClosure(interfaceClassInfo, index)) continue;
            return true;
        }
        return classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null && ValueResolverGenerator.hasClassInTypeClosure(superClassInfo, className, index);
    }

    public static boolean isVarArgs(MethodInfo method) {
        return (method.flags() & 0x80) != 0;
    }

    static class MethodKey
    implements Comparable<MethodKey> {
        final String name;
        final List<DotName> params;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = method;
            this.name = method.name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameters()) {
                this.params.add(i.name());
            }
        }

        public MethodInfo getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(MethodKey other) {
            int res = this.name.compareTo(other.name);
            if (res == 0 && (res = Integer.compare(this.params.size(), other.params.size())) == 0) {
                for (int i = 0; i < this.params.size() && (res = this.params.get(i).compareTo(other.params.get(i))) == 0; ++i) {
                }
            }
            return res;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.params.equals(other.params);
        }
    }

    private static class Match {
        final String name;
        final int paramsCount;

        public Match(String name, int paramsCount) {
            this.name = name;
            this.paramsCount = paramsCount;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.paramsCount);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Match other = (Match)obj;
            return Objects.equals(this.name, other.name) && this.paramsCount == other.paramsCount;
        }
    }

    public static class Builder {
        private IndexView index;
        private ClassOutput classOutput;
        private final Map<DotName, ClassInfo> nameToClass = new HashMap<DotName, ClassInfo>();
        private final Map<DotName, AnnotationInstance> nameToTemplateData = new HashMap<DotName, AnnotationInstance>();

        public Builder setIndex(IndexView index) {
            this.index = index;
            return this;
        }

        public Builder setClassOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder addClass(ClassInfo clazz) {
            return this.addClass(clazz, null);
        }

        public Builder addClass(ClassInfo clazz, AnnotationInstance templateData) {
            this.nameToClass.put(clazz.name(), clazz);
            if (templateData != null) {
                this.nameToTemplateData.put(clazz.name(), templateData);
            }
            return this;
        }

        public ValueResolverGenerator build() {
            return new ValueResolverGenerator(this.index, this.classOutput, this.nameToClass, this.nameToTemplateData);
        }
    }
}

