/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.os;

import io.smallrye.common.os.OS;
import io.smallrye.common.os.ProcessInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.regex.Pattern;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class GetAllProcessesInfoAction
implements PrivilegedAction<List<ProcessInfo>> {
    private static final Predicate<String> IS_NUMBER = Pattern.compile("\\d+").asPredicate();

    GetAllProcessesInfoAction() {
    }

    @Override
    public List<ProcessInfo> run() {
        switch (OS.current()) {
            case LINUX: {
                return this.readLinuxProcesses();
            }
            case MAC: {
                return this.readMacProcesses();
            }
            case WINDOWS: {
                return this.readWindowsProcesses();
            }
        }
        throw new UnsupportedOperationException("Listing all processes is not supported in JDK 8 in " + OS.current().name());
    }

    private List<ProcessInfo> readLinuxProcesses() {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get("/proc", new String[0]));){
            for (Path procPath : stream) {
                String name = procPath.getFileName().toString();
                if (!IS_NUMBER.test(name)) continue;
                long pid = Long.parseLong(name);
                try {
                    BufferedReader reader = Files.newBufferedReader(procPath.resolve("cmdline"), StandardCharsets.UTF_8);
                    try {
                        String line = reader.readLine();
                        if (line == null) continue;
                        int idx = line.indexOf(0);
                        String cmdLine = idx == -1 ? line : line.substring(0, idx);
                        processes.add(new ProcessInfo(pid, cmdLine));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProcessInfo> readMacProcesses() {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("ps", "-ax", "-o", "pid=,comm=");
            String thisCmd = String.join((CharSequence)" ", processBuilder.command());
            process = processBuilder.start();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                while (scanner.hasNextLine()) {
                    int separator;
                    String line = scanner.nextLine().trim();
                    String cmd = line.substring((separator = line.indexOf(" ")) + 1);
                    if (thisCmd.equals(cmd)) continue;
                    long pid = Long.parseLong(line.substring(0, separator));
                    processes.add(new ProcessInfo(pid, cmd));
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return processes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProcessInfo> readWindowsProcesses() {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("tasklist.exe", "/fo", "csv", "/nh");
            String thisCmd = String.join((CharSequence)" ", processBuilder.command());
            process = processBuilder.start();
            try (Scanner sc = new Scanner(process.getInputStream());){
                if (sc.hasNextLine()) {
                    sc.nextLine();
                }
                while (sc.hasNextLine()) {
                    String line = sc.nextLine().trim();
                    String[] parts = line.split(",");
                    String cmdLine = parts[0].substring(1).replaceFirst(".$", "");
                    if (thisCmd.equals(cmdLine)) continue;
                    long pid = Long.parseLong(parts[1].substring(1).replaceFirst(".$", ""));
                    processes.add(new ProcessInfo(pid, cmdLine));
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return processes;
    }
}

