/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.DemandPacer;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MultiDemandPacer<T>
extends AbstractMultiOperator<T, T> {
    private final ScheduledExecutorService executor;
    private final DemandPacer pacer;

    public MultiDemandPacer(Multi<? extends T> upstream, ScheduledExecutorService executor, DemandPacer pacer) {
        super(upstream);
        this.executor = executor;
        this.pacer = pacer;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.upstream.subscribe(new MultiSubscriptionPacerProcessor<T>(subscriber, this.executor, this.pacer));
    }

    private static class MultiSubscriptionPacerProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final ScheduledExecutorService executor;
        private final DemandPacer pacer;
        private final AtomicLong itemsCounter = new AtomicLong();
        private ScheduledFuture<?> scheduledFuture;
        private DemandPacer.Request currentRequest;

        MultiSubscriptionPacerProcessor(MultiSubscriber<? super T> downstream, ScheduledExecutorService executor, DemandPacer pacer) {
            super(downstream);
            this.executor = executor;
            this.pacer = pacer;
        }

        @Override
        public Context context() {
            if (this.downstream instanceof ContextSupport) {
                return ((ContextSupport)((Object)this.downstream)).context();
            }
            return Context.empty();
        }

        private void demandAndSchedule(ScheduledExecutorService executor) {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            long demand = this.currentRequest.demand();
            long delay = this.currentRequest.delay().toNanos();
            this.scheduledFuture = executor.schedule(this::tick, delay, TimeUnit.NANOSECONDS);
            this.upstream.request(demand);
        }

        private void tick() {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            long numberOfItemsEmitted = this.itemsCounter.getAndSet(0L);
            try {
                this.currentRequest = this.pacer.apply(this.currentRequest, numberOfItemsEmitted);
                if (this.currentRequest == null) {
                    this.cancel();
                    this.downstream.onFailure(new NullPointerException("The pacer provided a null request"));
                    return;
                }
            }
            catch (Throwable failure) {
                this.cancel();
                this.downstream.onFailure(failure);
                return;
            }
            this.demandAndSchedule(this.executor);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                this.downstream.onSubscribe(this);
                try {
                    this.currentRequest = this.pacer.initial();
                }
                catch (Throwable failure) {
                    this.cancel();
                    this.downstream.onFailure(failure);
                    return;
                }
                if (this.currentRequest == null) {
                    this.cancel();
                    this.downstream.onFailure(new NullPointerException("The pacer provided a null initial request"));
                } else {
                    this.demandAndSchedule(this.executor);
                }
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            this.itemsCounter.incrementAndGet();
            this.downstream.onItem(item);
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            this.cancel();
            this.downstream.onFailure(failure);
        }

        @Override
        public void onCompletion() {
            if (this.upstream == Subscriptions.CANCELLED) {
                return;
            }
            this.cancel();
            this.downstream.onCompletion();
        }

        @Override
        public void cancel() {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            super.cancel();
        }

        @Override
        public void request(long numberOfItems) {
        }
    }
}

