/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.vertx.core.Context;
import io.vertx.kafka.client.consumer.KafkaReadStream;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import io.vertx.mutiny.core.Vertx;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.errors.InterruptException;

public class ContextHolder {
    protected final Vertx vertx;
    private final int timeout;
    protected volatile io.vertx.mutiny.core.Context context;

    public ContextHolder(Vertx vertx, int defaultTimeout) {
        this.vertx = vertx;
        this.timeout = defaultTimeout;
    }

    public void capture(KafkaReadStream<?, ?> stream) {
        if (!(stream instanceof KafkaReadStreamImpl)) {
            throw new IllegalArgumentException("Cannot capture the context - not a KafkaReadStreamImpl");
        }
        try {
            Field field = KafkaReadStreamImpl.class.getDeclaredField("context");
            field.setAccessible(true);
            this.context = new io.vertx.mutiny.core.Context((Context)field.get(stream));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot capture the context", e);
        }
    }

    public io.vertx.mutiny.core.Context getContext() {
        return this.context;
    }

    public void runOnContext(Runnable runnable) {
        if (Vertx.currentContext() == this.context) {
            runnable.run();
        } else {
            this.context.runOnContext(x -> runnable.run());
        }
    }

    public <T> T runOnContextAndAwait(Callable<T> action) {
        FutureTask<T> task = new FutureTask<T>(action);
        this.runOnContext(task);
        try {
            return task.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new CompletionException(e);
        }
    }
}

