/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.smallrye.reactive.messaging.mqtt.MqttMessage;
import io.smallrye.reactive.messaging.mqtt.SendingMqttMessageMetadata;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public final class SendingMqttMessage<T>
implements MqttMessage<T> {
    private final T payload;
    private final Supplier<CompletionStage<Void>> ack;
    private final SendingMqttMessageMetadata sendingMetadata;
    private final Metadata metadata;

    SendingMqttMessage(T payload, SendingMqttMessageMetadata metadata, Supplier<CompletionStage<Void>> ack) {
        this.payload = payload;
        this.ack = ack;
        this.sendingMetadata = metadata;
        this.metadata = Metadata.of((Object[])new Object[]{this.sendingMetadata});
    }

    SendingMqttMessage(T payload, SendingMqttMessageMetadata metadata) {
        this(payload, metadata, null);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CompletionStage<Void> ack() {
        if (this.ack != null) {
            return this.ack.get();
        }
        return CompletableFuture.completedFuture(null);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public T getPayload() {
        return this.payload;
    }

    @Override
    public int getMessageId() {
        return -1;
    }

    @Override
    public MqttQoS getQosLevel() {
        return this.sendingMetadata.getQosLevel();
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public boolean isRetain() {
        return this.sendingMetadata.isRetain();
    }

    @Override
    public String getTopic() {
        return this.sendingMetadata.getTopic();
    }
}

