/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.stork.api.config.LoadBalancerConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryConfig;

public class ServiceDefinition {
    private final LoadBalancerConfig loadBalancer;
    private final ServiceDiscoveryConfig serviceDiscovery;

    private ServiceDefinition(ServiceDiscoveryConfig sd, LoadBalancerConfig lb) {
        this.serviceDiscovery = (ServiceDiscoveryConfig)ParameterValidation.nonNull((Object)sd, (String)"service discovery config");
        this.loadBalancer = lb;
    }

    public static ServiceDefinition of(ServiceDiscoveryConfig sd) {
        return ServiceDefinition.of(sd, null);
    }

    public static ServiceDefinition of(ServiceDiscoveryConfig sd, LoadBalancerConfig lb) {
        return new ServiceDefinition(sd, lb);
    }

    public LoadBalancerConfig getLoadBalancer() {
        return this.loadBalancer;
    }

    public ServiceDiscoveryConfig getServiceDiscovery() {
        return this.serviceDiscovery;
    }
}

