/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.spi.config;

import io.smallrye.stork.api.config.LoadBalancerConfig;
import io.smallrye.stork.api.config.ServiceConfig;
import io.smallrye.stork.api.config.ServiceDiscoveryConfig;
import java.util.Collections;
import java.util.Map;

public class SimpleServiceConfig
implements ServiceConfig {
    private final String serviceName;
    private final LoadBalancerConfig loadBalancerConfig;
    private final ServiceDiscoveryConfig serviceDiscoveryConfig;

    private SimpleServiceConfig(String serviceName, LoadBalancerConfig loadBalancerConfig, ServiceDiscoveryConfig serviceDiscoveryConfig) {
        this.serviceName = serviceName;
        this.loadBalancerConfig = loadBalancerConfig;
        this.serviceDiscoveryConfig = serviceDiscoveryConfig;
    }

    @Override
    public String serviceName() {
        return this.serviceName;
    }

    @Override
    public LoadBalancerConfig loadBalancer() {
        return this.loadBalancerConfig;
    }

    @Override
    public ServiceDiscoveryConfig serviceDiscovery() {
        return this.serviceDiscoveryConfig;
    }

    public static class SimpleServiceDiscoveryConfig
    implements ServiceDiscoveryConfig {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleServiceDiscoveryConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class SimpleLoadBalancerConfig
    implements LoadBalancerConfig {
        private final String type;
        private final Map<String, String> parameters;

        public SimpleLoadBalancerConfig(String type, Map<String, String> parameters) {
            this.type = type;
            this.parameters = Collections.unmodifiableMap(parameters);
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public Map<String, String> parameters() {
            return this.parameters;
        }
    }

    public static class Builder {
        String serviceName;
        LoadBalancerConfig loadBalancerConfig;
        ServiceDiscoveryConfig serviceDiscoveryConfig;
        boolean secure;

        public Builder setLoadBalancer(LoadBalancerConfig loadBalancer) {
            this.loadBalancerConfig = loadBalancer;
            return this;
        }

        public Builder setServiceDiscovery(ServiceDiscoveryConfig serviceDiscovery) {
            this.serviceDiscoveryConfig = serviceDiscovery;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public SimpleServiceConfig build() {
            return new SimpleServiceConfig(this.serviceName, this.loadBalancerConfig, this.serviceDiscoveryConfig);
        }
    }
}

