/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import java.io.IOException;

public class TIFFLSBDecompressor
extends TIFFDecompressor {
    private static byte[] flipTable = TIFFFaxDecompressor.flipTable;

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        this.stream.seek(this.offset);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            int numBytes = bytesPerRow * this.srcHeight;
            this.stream.readFully(b, dstOffset, numBytes);
            int xMax = dstOffset + numBytes;
            for (int x = dstOffset; x < xMax; ++x) {
                b[x] = flipTable[b[x] & 0xFF];
            }
        } else {
            for (int y = 0; y < this.srcHeight; ++y) {
                this.stream.readFully(b, dstOffset, bytesPerRow);
                int xMax = dstOffset + bytesPerRow;
                for (int x = dstOffset; x < xMax; ++x) {
                    b[x] = flipTable[b[x] & 0xFF];
                }
                dstOffset += scanlineStride;
            }
        }
    }
}

