/*
 * Decompiled with CFR 0.152.
 */
package trace.appender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import trace.appender.Message;

public class TraceAppender
extends ConsoleAppender {
    public static final long DEFAULT_ELAPSED_TIME = 3000L;
    protected Map<String, Message> called = Collections.synchronizedMap(new HashMap());
    protected final Logger log = LogManager.getLogger(TraceAppender.class);
    protected Collection<String> notAllowableMessages = Collections.synchronizedCollection(new ArrayList());

    public void addMessageToVerify(String msg) {
        this.addMessageToVerify(msg, -1);
    }

    public void addMessageToVerify(String msg, int expectedTimes) {
        Message message = new Message(msg, true, expectedTimes);
        this.called.put(msg, message);
    }

    public void addNotAllowableMessage(String message) {
        this.notAllowableMessages.add(message);
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        String msg = loggingEvent.getMessage().toString();
        if (this.called.containsKey(msg)) {
            this.called.get(msg).increaseCalledTimes();
        } else {
            Message message = new Message(msg, false, -1);
            message.increaseCalledTimes();
            this.called.put(msg, message);
        }
    }

    private void printResults() {
        StringBuffer retorno = new StringBuffer();
        Iterator<String> i = this.called.keySet().iterator();
        while (i.hasNext()) {
            Message msg = this.called.get(i.next());
            if (!msg.isShouldCall()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Logging message '").append(msg.getMessage()).append("' ");
            sb.append("was ");
            if (msg.isShouldCall()) {
                sb.append("expected ");
                if (msg.getExpectedTimes() > 0) {
                    sb.append("to called ");
                    sb.append(msg.getExpectedTimes());
                    sb.append(" times ");
                }
            } else {
                sb.append("not expected ");
            }
            sb.append(msg.wasCalled() ? "and called " : "and was not called ");
            sb.append(msg.getCalledTimes() + " times");
            retorno.append(sb.toString());
            retorno.append(System.getProperty("line.separator"));
        }
        this.log.debug((Object)retorno.toString());
    }

    public void verify() {
        try {
            this.verifyExpectedMessages();
        }
        catch (AssertionError e) {
            this.printResults();
            throw e;
        }
        this.verifyNotAllowedMessages();
        this.log.debug((Object)"verify: all messages was logged correctly.");
    }

    public void verify(long elapsedTime) {
        block3: {
            long partialTime;
            long start = System.currentTimeMillis();
            do {
                boolean sucess = true;
                try {
                    this.verifyExpectedMessages();
                }
                catch (AssertionError e) {
                    sucess = false;
                }
                this.verifyNotAllowedMessages();
                if (sucess) break block3;
            } while ((partialTime = System.currentTimeMillis() - start) <= elapsedTime);
            this.printResults();
            throw new AssertionError((Object)"The elapsed time is greater than the expected time.");
        }
    }

    void verifyExpectedMessages() throws AssertionError {
        Iterator<String> i = this.called.keySet().iterator();
        while (i.hasNext()) {
            Message msg = this.called.get(i.next());
            if (!msg.isShouldCall()) continue;
            if (!msg.wasCalled()) {
                throw new AssertionError((Object)("Message not logged: " + msg.getMessage()));
            }
            int expectedTimes = msg.getExpectedTimes();
            int calledTimes = msg.getCalledTimes();
            if (expectedTimes > 0 && expectedTimes != calledTimes) {
                throw new AssertionError((Object)("The was logged " + calledTimes + " times, but should be logged " + expectedTimes + " times."));
            }
        }
    }

    void verifyNotAllowedMessages() throws AssertionError {
        for (String message : this.notAllowableMessages) {
            if (this.called.containsKey(message)) {
                throw new AssertionError((Object)("The message not allowed was logged: '" + message + "'."));
            }
        }
    }
}

