/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import net.intelie.live.ElementState;
import net.intelie.live.PrefixedLive;

public abstract class ElementHandle {
    public static final Constant INACTIVE = new Constant(ElementState.INACTIVE);
    public static final Constant OK = new Constant(ElementState.OK);

    public void refresh() {
    }

    public void close() {
    }

    public abstract ElementState status();

    public static class Merged
    extends ElementHandle {
        private final ElementState status;
        private final ElementHandle other;

        public Merged(ElementState status, ElementHandle other) {
            this.status = status;
            this.other = other;
        }

        @Override
        public ElementState status() {
            return this.status.merge(this.other.status());
        }

        @Override
        public void close() {
            this.other.close();
        }

        @Override
        public void refresh() {
            this.other.refresh();
        }
    }

    public static class Constant
    extends ElementHandle {
        private final ElementState status;

        public Constant(ElementState status) {
            this.status = status;
        }

        @Override
        public ElementState status() {
            return this.status;
        }
    }

    public static class Default
    extends ElementHandle {
        private final PrefixedLive live;

        public Default(PrefixedLive live) {
            this.live = live;
        }

        @Override
        public ElementState status() {
            return ElementState.OK;
        }

        @Override
        public void close() {
            this.live.undoAll();
        }
    }
}

