/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Objects;
import net.intelie.live.InputStreamSource;

public class EmailAttachment {
    private String name;
    private InputStreamSource content;
    private String contentType;
    private Disposition disposition;

    public EmailAttachment(String name, InputStreamSource content, String contentType, Disposition disposition) {
        this.name = name;
        this.content = content;
        this.contentType = contentType;
        this.disposition = disposition;
    }

    public EmailAttachment(String name, byte[] content, String contentType, Disposition disposition) {
        this.name = name;
        this.content = () -> new ByteArrayInputStream(content);
        this.contentType = contentType;
        this.disposition = disposition;
    }

    public EmailAttachment(String name, String content, Charset encoding, String contentType, Disposition disposition) throws UnsupportedEncodingException {
        this.name = name;
        this.contentType = contentType;
        this.disposition = disposition;
        this.content = () -> new ByteArrayInputStream(content.getBytes(encoding));
    }

    public String getName() {
        return this.name;
    }

    public InputStreamSource getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAttachment that = (EmailAttachment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.contentType, that.contentType) && this.disposition == that.disposition;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.contentType, this.disposition});
    }

    public String toString() {
        return "EmailAttachment{name='" + this.name + '\'' + ", contentType='" + this.contentType + '\'' + ", disposition=" + (Object)((Object)this.disposition) + '}';
    }

    public static enum Disposition {
        ATTACHMENT,
        INLINE;

    }
}

