/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.live.EmailAttachment;

public class EmailMessage {
    private String subject;
    private String text;
    private List<EmailAttachment> attachments;
    private String[] recipients;

    public EmailMessage(String subject, String text, List<EmailAttachment> attachments, List<String> recipients) {
        this(subject, text, attachments, recipients == null ? new String[]{} : recipients.toArray(new String[0]));
    }

    public EmailMessage(String subject, String text, List<EmailAttachment> attachments, String ... recipients) {
        if (recipients == null || recipients.length == 0) {
            throw new IllegalArgumentException("Recipients list is null or empty");
        }
        this.subject = subject;
        this.text = text;
        this.attachments = attachments;
        this.recipients = recipients;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public String[] getRecipients() {
        return this.recipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailMessage that = (EmailMessage)o;
        return Objects.equals(this.subject, that.subject) && Objects.equals(this.text, that.text) && Objects.equals(this.attachments, that.attachments) && Arrays.equals(this.recipients, that.recipients);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.text, this.attachments, this.recipients);
    }

    public String toString() {
        return "EmailMessage{subject='" + this.subject + '\'' + ", text='" + this.text + '\'' + ", attachments=" + this.attachments + ", recipients=" + Arrays.toString(this.recipients) + '}';
    }
}

