/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.intelie.live.Callback;
import net.intelie.live.EntityContext;
import net.intelie.live.EntityList;
import net.intelie.live.SettingsOptions;
import net.intelie.live.SettingsProvider;
import net.intelie.live.model.Setting;
import net.intelie.live.model.SettingLog;
import net.intelie.live.queries.AllSettings;
import net.intelie.live.queries.SettingIdsExistence;
import net.intelie.live.util.PathUtils;

public class EntitySettingsProvider
implements SettingsProvider {
    private final SettingsOptions.Stack transaction = new SettingsOptions.Stack(true);
    private final SettingsOptions.Stack log = new SettingsOptions.Stack(true);
    private final EntityContext entities;

    public EntitySettingsProvider(EntityContext entities) {
        this.entities = entities;
    }

    @Override
    public String get(String path) {
        return this.transact(path, () -> {
            Setting setting = this.entities.get(Setting.class, (Serializable)((Object)path));
            if (setting == null) {
                return null;
            }
            return String.valueOf(setting.getValue());
        });
    }

    @Override
    public Set<String> checkPaths(Set<String> paths) {
        return (Set)this.transact(null, () -> Sets.difference((Set)paths, new HashSet<String>(this.entities.find(new SettingIdsExistence(paths)).getEntities())));
    }

    @Override
    public List<SettingsProvider.Holder> getChildren(String path, int levels) {
        return this.transact(path, () -> {
            int level = PathUtils.level(path);
            EntityList<Setting> entities = this.entities.find(new AllSettings().byIdPrefixAndLevel(path, level + 1, level + levels));
            return entities.getEntities().stream().map(x -> new SettingsProvider.Holder(x.getId(), x.getValue())).collect(Collectors.toList());
        });
    }

    @Override
    public synchronized void set(String path, String content) {
        this.transact(path, () -> {
            Setting setting = this.entities.get(Setting.class, (Serializable)((Object)path));
            boolean create = false;
            if (setting == null) {
                setting = new Setting(path);
                setting.setLevel(PathUtils.level(path));
                create = true;
            }
            String oldValue = setting.getValue();
            setting.setValue(content);
            this.entities.save(setting);
            this.log(create ? "create" : "set", path, oldValue, content);
            return null;
        });
    }

    private void log(String op, String path, String oldValue, String newValue) {
        if (!this.log.value()) {
            return;
        }
        SettingLog log = new SettingLog();
        log.setSettingId(path);
        log.setLevel(PathUtils.level(path));
        log.setOperation(op);
        log.setOldValue(oldValue);
        log.setNewValue(newValue);
        this.entities.save(log);
    }

    @Override
    public synchronized void delete(String path) {
        this.transact(path, () -> {
            int level = PathUtils.level(path);
            EntityList<Setting> list = this.entities.find(new AllSettings().byIdPrefixAndLevel(path, level, level + 512));
            for (Setting setting : list) {
                this.log("delete", setting.getId(), setting.getValue(), null);
                this.entities.delete(setting);
            }
            return null;
        });
    }

    private <T, E extends Throwable> T transact(String path, Callback<T, E> callback) throws E {
        return this.transact(new SettingsOptions(), path, callback);
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T, E extends Throwable> T transact(SettingsOptions options, String path, Callback<T, E> callback) throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

