/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Objects;
import net.intelie.pipes.util.Preconditions;

public class ExtensionQualifier {
    private final String type;
    private final String qualifier;

    public ExtensionQualifier(String type, String qualifier) {
        Preconditions.checkNotNull((Object)type, (Object)"extension type must be not null");
        this.type = type;
        this.qualifier = qualifier != null ? qualifier : "";
    }

    public static String makeFull(String type, String qualifier) {
        if (qualifier == null || "".equals(qualifier)) {
            return type;
        }
        return type + "/" + qualifier;
    }

    public String type() {
        return this.type;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String fullQualifier() {
        return ExtensionQualifier.makeFull(this.type, this.qualifier);
    }

    public String toString() {
        return this.fullQualifier();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionQualifier that = (ExtensionQualifier)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.qualifier, that.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.qualifier);
    }
}

