/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public enum ExtensionRole {
    INPUT,
    NOTIFICATION,
    QUERY,
    STORAGE,
    UI,
    AUTH,
    OUTPUT;


    public static Builder start() {
        return new Builder();
    }

    public Set<ExtensionRole> asSet() {
        return Collections.singleton(this);
    }

    public static class Builder {
        private final Set<ExtensionRole> set = new LinkedHashSet<ExtensionRole>();

        public Builder with(ExtensionRole ... values) {
            Builder builder = this;
            for (ExtensionRole value : values) {
                builder = builder.define(true, value);
            }
            return builder;
        }

        public Builder define(boolean on, ExtensionRole value) {
            if (on) {
                this.set.add(value);
            }
            return this;
        }

        public Set<ExtensionRole> ok() {
            return this.set;
        }
    }
}

