/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.live;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.live.Event;

public class IndexDef {
    private final boolean sparse;
    private final String type;
    private final List<String> properties;

    private IndexDef(boolean sparse, String type, List<String> properties) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type must not be empty");
        Preconditions.checkArgument((properties != null && !properties.isEmpty() ? 1 : 0) != 0, (Object)"properties must not be empty");
        Preconditions.checkArgument((boolean)properties.stream().noneMatch(Strings::isNullOrEmpty), (Object)"field name must not be empty");
        this.sparse = sparse;
        this.type = Event.normalize(type);
        this.properties = properties;
    }

    public IndexDef(String type, String ... properties) {
        this(type, Arrays.asList(properties));
    }

    public IndexDef(String type, List<String> properties) {
        this(false, type, properties);
    }

    public IndexDef withSparse(boolean sparse) {
        return new IndexDef(sparse, this.type, this.properties);
    }

    public boolean sparse() {
        return this.sparse;
    }

    public String type() {
        return this.type;
    }

    public List<String> properties() {
        return this.properties;
    }

    public String toString() {
        return this.type + (this.sparse ? "*" : "") + "(" + Joiner.on((String)", ").join(this.properties) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDef indexDef = (IndexDef)o;
        return Objects.equals(this.sparse, indexDef.sparse) && Objects.equals(this.type, indexDef.type) && Objects.equals(this.properties, indexDef.properties);
    }

    public int hashCode() {
        return Objects.hash(this.sparse, this.type, this.properties);
    }
}

